/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.ServiceInfo;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ContextMgr
implements CommandListener {
    private static final Logger log = Logger.getLogger(ContextMgr.class);
    private static final ContextMgr instance = new ContextMgr();
    private static final String APP_RESTART_ACT = "AppRestart";
    protected Taskable currentContext = null;
    protected Vector<Taskable> tasks = new Vector();
    protected Hashtable<String, ServiceInfo> services = new Hashtable();
    protected Hashtable<Integer, List<ServiceInfo>> servicesByTable = new Hashtable();
    protected Vector<ServiceInfo> genericService = new Vector();

    protected ContextMgr() {
        CommandDispatcher.register("App", this);
    }

    public static Taskable getCurrentContext() {
        return ContextMgr.instance.currentContext;
    }

    public static void requestContext(Taskable task) {
        if (task != ContextMgr.instance.currentContext) {
            if (ContextMgr.instance.currentContext != null) {
                NavBoxMgr.unregister();
            }
            if (task != null) {
                NavBoxMgr.register(task);
            }
            ContextMgr.instance.currentContext = task;
        }
    }

    public static void register(Taskable task) {
        ContextMgr.instance.tasks.addElement(task);
    }

    public static void unregister(Taskable task) {
        ContextMgr.instance.tasks.removeElement(task);
    }

    public static Taskable getTaskByName(String name) {
        if (name == null) {
            throw new NullPointerException("Name arg is null in getTaskByName");
        }
        for (Taskable task : ContextMgr.instance.tasks) {
            if (!name.equals(task.getName())) continue;
            return task;
        }
        log.error((Object)("Couldn't find task by name[" + name + "]"));
        return null;
    }

    public static Taskable getTaskByClass(Class<?> theClass) {
        if (theClass == null) {
            throw new NullPointerException("Class arg is null in getTaskByClass");
        }
        for (Taskable task : ContextMgr.instance.tasks) {
            if (task.getClass() != theClass) continue;
            return task;
        }
        log.error((Object)("Couldn't find task by class [" + theClass.getSimpleName() + "]"));
        return null;
    }

    public static ServiceInfo registerService(Integer priority, String serviceName, int tableId, CommandAction command, Taskable task, String iconName, String tooltip) {
        return ContextMgr.registerService(priority, serviceName, tableId, command, task, iconName, tooltip, false);
    }

    public static ServiceInfo registerService(Integer priority, String serviceName, int tableId, CommandAction command, Taskable task, String iconName, String tooltip, boolean isDefault) {
        String hashName = ServiceInfo.getHashKey(serviceName, task, tableId);
        if (ContextMgr.instance.services.get(hashName) != null) {
            return null;
        }
        ServiceInfo serviceInfo = new ServiceInfo(priority, serviceName, tableId, command, task, iconName, tooltip, isDefault);
        return ContextMgr.registerService(serviceInfo);
    }

    public static ServiceInfo registerService(ServiceInfo serviceInfo) {
        String hashName = ServiceInfo.getHashKey(serviceInfo.getName(), serviceInfo.getTask(), serviceInfo.getTableId());
        if (serviceInfo.getTableId() != -1) {
            ContextMgr.instance.services.put(hashName, serviceInfo);
            List<ServiceInfo> serviceList = ContextMgr.instance.servicesByTable.get(serviceInfo.getTableId());
            if (serviceList == null) {
                serviceList = new ArrayList<ServiceInfo>();
                ContextMgr.instance.servicesByTable.put(serviceInfo.getTableId(), serviceList);
            }
            serviceList.add(serviceInfo);
            return serviceInfo;
        }
        ContextMgr.instance.genericService.add(serviceInfo);
        ContextMgr.instance.services.put(hashName, serviceInfo);
        return null;
    }

    public static void unregisterService(String hashName) {
        ServiceInfo srvInfo = ContextMgr.instance.services.get(hashName);
        if (srvInfo != null) {
            ContextMgr.instance.services.remove(hashName);
            if (srvInfo.getTableId() > -1) {
                List<ServiceInfo> serviceList = ContextMgr.instance.servicesByTable.get(srvInfo.getTableId());
                if (serviceList != null) {
                    serviceList.remove(srvInfo);
                }
            } else {
                ContextMgr.instance.genericService.remove(srvInfo);
            }
        } else {
            log.error((Object)("Couldn't find service [" + hashName + "]"));
        }
    }

    public static ServiceInfo getDefaultService() {
        for (ServiceInfo si : ContextMgr.instance.services.values()) {
            if (!si.isDefault()) continue;
            if (AppContextMgr.isSecurityOn() && !si.isPermissionOK()) {
                return null;
            }
            return si;
        }
        return null;
    }

    public static void removeServicesByTask(Taskable task) {
        Vector<ServiceInfo> list = new Vector<ServiceInfo>(ContextMgr.instance.services.values());
        for (ServiceInfo serviceInfo : list) {
            if (serviceInfo.getTask() != task) continue;
            ContextMgr.instance.services.remove(ServiceInfo.getHashKey(serviceInfo.getName(), serviceInfo.getTask(), serviceInfo.getTableId()));
        }
        for (Collection collection : ContextMgr.instance.servicesByTable.values()) {
            for (ServiceInfo srv : new Vector(collection)) {
                if (srv.getTask() != task) continue;
                collection.remove(srv);
            }
        }
        for (ServiceInfo serviceInfo : new Vector<ServiceInfo>(ContextMgr.instance.genericService)) {
            if (serviceInfo.getTask() != task) continue;
            ContextMgr.instance.genericService.remove(serviceInfo);
        }
    }

    public static void removeServicesByTaskAndTable(Taskable task, int tableId) {
        Vector<ServiceInfo> list = new Vector<ServiceInfo>(ContextMgr.instance.services.values());
        for (ServiceInfo serviceInfo : list) {
            if (serviceInfo.getTask() != task || serviceInfo.getTableId() != tableId) continue;
            ContextMgr.instance.services.remove(serviceInfo.getName());
        }
        for (Collection collection : ContextMgr.instance.servicesByTable.values()) {
            for (ServiceInfo srv : new Vector(collection)) {
                if (srv.getTask() != task) continue;
                collection.remove(srv);
            }
        }
    }

    public static List<ServiceInfo> checkForServices(int tableId) {
        boolean isSecurityOn;
        List<ServiceInfo> serviceList = ContextMgr.instance.servicesByTable.get(tableId);
        if (serviceList == null) {
            serviceList = new ArrayList<ServiceInfo>();
        }
        if (isSecurityOn = AppContextMgr.isSecurityOn()) {
            for (ServiceInfo srvInfo : new ArrayList<ServiceInfo>(serviceList)) {
                if (srvInfo.isPermissionOK()) continue;
                log.debug((Object)("Removing Service: " + srvInfo.getName() + "  " + srvInfo.getTableId()));
                serviceList.remove(srvInfo);
            }
        }
        for (ServiceInfo srvInfo : ContextMgr.instance.genericService) {
            if (serviceList.contains(srvInfo)) continue;
            if (isSecurityOn && !srvInfo.isPermissionOK()) {
                log.debug((Object)("Skipping Service: " + srvInfo.getName() + "  " + srvInfo.getTableId()));
                continue;
            }
            if (!srvInfo.isAvailable(tableId)) continue;
            serviceList.add(srvInfo);
        }
        Collections.sort(serviceList);
        return serviceList;
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isAction(APP_RESTART_ACT) && AppContextMgr.isSecurityOn()) {
            for (ServiceInfo srvInfo : ContextMgr.instance.genericService) {
                srvInfo.resetPermissions();
            }
        }
    }

    public static void dump() {
        for (Integer tableId : ContextMgr.instance.servicesByTable.keySet()) {
            DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoById(tableId);
            System.out.println("------------------" + tableInfo.getTitle() + "------------------");
            for (ServiceInfo s : ContextMgr.instance.servicesByTable.get(tableId)) {
                System.out.println("Name:      " + s.getName());
                System.out.println("Task Name: " + s.getTask().getName());
                System.out.println("\n");
            }
        }
    }
}

