/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.persist.ViewSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Element;

public abstract class AppContextMgr {
    public static final String factoryName = "edu.ku.brc.af.core.AppContextMgrFactory";
    protected static AppContextMgr instance = null;
    protected CONTEXT_STATUS currentStatus = CONTEXT_STATUS.Initial;
    protected Hashtable<Class<?>, Object> classObjHash = new Hashtable();
    protected boolean hasContext = false;

    public abstract ViewIFace getView(String var1);

    public abstract ViewIFace getView(String var1, String var2);

    public abstract AppResourceIFace getResource(String var1);

    public abstract AppResourceIFace getResourceFromDir(String var1, String var2);

    public abstract List<AppResourceIFace> getResourceByMimeType(String var1);

    public abstract Element getResourceAsDOM(String var1);

    public abstract Element getResourceAsDOM(AppResourceIFace var1);

    public abstract String getResourceAsXML(String var1);

    public abstract String getResourceAsXML(AppResourceIFace var1);

    public abstract void putResourceAsXML(String var1, String var2);

    public abstract void putResourceAsXML(AppResourceIFace var1, String var2);

    public abstract AppResourceIFace createAppResourceForDir(String var1);

    public abstract boolean removeAppResource(String var1, AppResourceIFace var2);

    public abstract boolean saveResource(AppResourceIFace var1);

    public abstract CONTEXT_STATUS setContext(String var1, String var2, boolean var3, boolean var4, boolean var5);

    public abstract Hashtable<String, List<ViewSetIFace>> getViewSetHash();

    public abstract String getCurrentContextDescription();

    public abstract UIFieldFormatterIFace getFormatter(String var1, String var2);

    public boolean hasContext() {
        return this.hasContext;
    }

    public void setHasContext(boolean hasContext) {
        this.hasContext = hasContext;
    }

    public Taskable getTaskFromTableId(int tableId) {
        return null;
    }

    public static boolean isSecurityOn() {
        return AppContextMgr.getInstance().isSecurity();
    }

    public void copy(AppResourceIFace fromAppRes, AppResourceIFace toAppRes) {
        toAppRes.setName(fromAppRes.getName());
        toAppRes.setDescription(fromAppRes.getDescription());
        toAppRes.setDataAsString(fromAppRes.getDataAsString());
        toAppRes.setLevel(fromAppRes.getLevel());
        toAppRes.setMetaData(fromAppRes.getMetaData());
        toAppRes.setMimeType(fromAppRes.getMimeType());
        toAppRes.setFileName(fromAppRes.getFileName());
    }

    public AppResourceIFace copyToDirAppRes(String appResDirName, String resourceName) {
        AppResourceIFace toAppRes = null;
        AppResourceIFace fromAppRes = this.getResource(resourceName);
        if (fromAppRes != null) {
            toAppRes = this.createAppResourceForDir(appResDirName);
            this.copy(fromAppRes, toAppRes);
        }
        return toAppRes;
    }

    public void setClassObject(Class<?> clazz, Object object) {
        if (!this.hasContext) {
            throw new RuntimeException("No context has been set.");
        }
        if (object == null) {
            if (this.classObjHash.get(clazz) != null) {
                this.classObjHash.remove(clazz);
            }
        } else {
            this.classObjHash.put(clazz, object);
        }
    }

    public <T> T getClassObject(Class<T> clazz) {
        if (!this.hasContext) {
            throw new RuntimeException("No context has been set.");
        }
        return (T)this.classObjHash.get(clazz);
    }

    public static AppContextMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(AppContextMgr.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = (AppContextMgr)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AppContextMgr.class, e);
                InternalError error = new InternalError("Can't instantiate AppContextMgr factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }

    public void clear() {
        this.classObjHash.clear();
    }

    public abstract boolean isSecurity();

    public abstract boolean setSecurity(boolean var1);

    public static enum CONTEXT_STATUS {
        OK,
        Error,
        Ignore,
        Initial;

    }
}

