/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.principal;

import edu.ku.brc.af.auth.specify.policy.DatabaseService;
import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserPrincipalSQLService {
    protected static final Logger log = Logger.getLogger(UserPrincipalSQLService.class);
    protected static final boolean isDebug = false;

    public static int getSpecifyUserId(SpPrincipal principal) {
        int result;
        block17: {
            result = -1;
            Connection conn = null;
            Statement pstmt = null;
            try {
                try {
                    conn = DatabaseService.getInstance().getConnection();
                    if (conn != null) {
                        pstmt = conn.prepareStatement("SELECT specifyuser_spprincipal.SpecifyUserID  FROM specifyuser_spprincipal WHERE SpPrincipalID=?");
                        pstmt.setInt(1, principal.getId());
                        ResultSet rs = pstmt.executeQuery();
                        if (rs.next()) {
                            result = rs.getInt("SpecifyUserID");
                        }
                        break block17;
                    }
                    log.error((Object)"getSpecifyUserId - database connection was null");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    log.error((Object)("Exception caught: " + e));
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        log.error((Object)("Exception caught: " + e2.toString()));
                        e2.printStackTrace();
                        UsageTracker.incrSQLUsageCount();
                        ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e2);
                    }
                }
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Exception caught: " + e.toString()));
                    e.printStackTrace();
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e);
                }
            }
        }
        return result;
    }

    public static boolean isPrincipalAdmin(Integer principalId) {
        String sql = "SELECT count(up.SpPrincipalID) as ct FROM specifyuser_spprincipal as up INNER JOIN spprincipal as p on (up.SpPrincipalID=p.SpPrincipalID) WHERE p.GroupSubClass='" + AdminPrincipal.class.getCanonicalName() + "'" + " AND up.SpecifyUserID=" + principalId;
        Integer count = BasicSQLUtils.getCount(sql);
        return count != null && count > 0;
    }

    protected static boolean performUpdate(String msg, String sql, Object ... args) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = DatabaseService.getInstance().getConnection();
            if (conn != null) {
                pstmt = conn.prepareStatement(sql);
                int i = 0;
                while (i < args.length) {
                    pstmt.setString(i + 1, args[i].toString());
                    ++i;
                }
                boolean bl = pstmt.executeUpdate() > 0;
                return bl;
            }
            try {
                log.error((Object)(String.valueOf(msg) + " - database connection was null"));
            }
            catch (SQLException e) {
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public static boolean deleteFromUserGroup(Integer userId, Integer userGroupId) {
        return UserPrincipalSQLService.performUpdate("deleteFromUserGroup", "DELETE FROM specifyuser_spprincipal WHERE SpecifyUserID=? AND SpPrincipalID=?", userId, userGroupId);
    }

    public static boolean addToUserGroup(Integer userId, Integer userGroupId) {
        return UserPrincipalSQLService.performUpdate("addToUserGroup", "INSERT INTO specifyuser_spprincipal VALUES (?, ?)", userId, userGroupId);
    }

    public static void addUser(String username, String password) throws SQLException {
        UserPrincipalSQLService.performUpdate("addUser", "INSERT INTO specifyuser (Name, Password) VALUES (?, ?)", username, password);
    }

    public static String getUsersIdByName(String userName) {
        Connection conn = null;
        String id = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = DatabaseService.getInstance().getConnection();
                pstmt = conn.prepareStatement("SELECT specifyuser.SpecifyUserID FROM specifyuser WHERE name=?");
                pstmt.setString(1, userName);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    id = rs.getString("SpecifyUserID");
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e);
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e2) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e2);
                    log.error((Object)("addUser Exception caught: " + e2.toString()));
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e);
                log.error((Object)("addUser Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
        return id;
    }

    public static Set<SpPrincipal> getUsersGroupsByUsername(String user) throws Exception {
        HashSet<SpPrincipal> principals = new HashSet<SpPrincipal>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                conn = DatabaseService.getInstance().getConnection();
                conn = DatabaseService.getInstance().getConnection();
                String myUserId = UserPrincipalSQLService.getUsersIdByName(user);
                String sql = "SELECT specifyuser_spprincipal.SpPrincipalID FROM specifyuser_spprincipal WHERE SpecifyUserID=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, myUserId);
                ResultSet spPrincipalIDSet = pstmt.executeQuery();
                while (spPrincipalIDSet.next()) {
                    String princId = spPrincipalIDSet.getString("SpPrincipalID");
                    Integer princIdInt = spPrincipalIDSet.getInt("SpPrincipalID");
                    sql = "SELECT distinct(spprincipal.name), spprincipal.groupsubclass FROM specifyuser_spprincipal, spprincipal WHERE (specifyuser_spprincipal.specifyuserid= ? AND specifyuser_spprincipal.spprincipalid= ? AND spprincipal.spprincipalid= ?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, myUserId);
                    pstmt.setString(2, princId);
                    pstmt.setString(3, princId);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String groupName = rs.getString("name");
                        String className = rs.getString("groupsubclass");
                        SpPrincipal grp = new SpPrincipal(princIdInt);
                        grp.setName(groupName);
                        grp.setGroupSubClass(className);
                        principals.add(grp);
                    }
                }
            }
            catch (SQLException e) {
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalSQLService.class, e);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return principals;
    }
}

