/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.principal;

import edu.ku.brc.af.auth.specify.policy.DatabaseService;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class UserPrincipalHibernateService {
    protected static final Logger log = Logger.getLogger(UserPrincipalHibernateService.class);

    public static SpPrincipal getUserPrincipalBySpecifyUser(SpecifyUser user) {
        DataProviderSessionIFace session = null;
        SpPrincipal principal = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                String sql = "FROM SpPrincipal as pc INNER JOIN FETCH pc.specifyUsers as sp WHERE groupSubClass='" + UserPrincipal.class.getCanonicalName() + "' AND sp.name = '" + user.getName() + "'";
                log.debug((Object)sql);
                List<?> lister = session.getDataList(sql);
                if (lister != null && lister.size() > 0) {
                    principal = (SpPrincipal)lister.get(0);
                    principal.getPermissions().size();
                }
            }
            catch (Exception e1) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e1);
                log.error((Object)("Exception caught: " + e1.toString()));
                e1.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return principal;
    }

    public static SpecifyUser getUserByName(String name) {
        DataProviderSessionIFace session = null;
        SpecifyUser user = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                List<SpecifyUser> lister = session.getDataList(SpecifyUser.class, "name", name);
                user = lister.get(0);
            }
            catch (Exception e1) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e1);
                log.error((Object)("Exception caught: " + e1.toString()));
                e1.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return user;
    }

    public static boolean addToUserGroup(SpecifyUser user, SpPrincipal group) {
        Connection conn = null;
        try {
            log.debug((Object)"executing sql to add user to group");
            conn = DatabaseService.getInstance().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO specifyuser_spprincipal VALUES (?, ?)");
            pstmt.setString(1, "" + user.getId());
            pstmt.setString(2, "" + group.getId());
            log.debug((Object)("executing: " + pstmt.toString()));
            int res = pstmt.executeUpdate();
            boolean bl = res > 0;
            return bl;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
            log.error((Object)("addToUserGroup - " + e));
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
                    log.error((Object)("Exception caught: " + e.toString()));
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static boolean isUserInGroup(SpecifyUser user, SpPrincipal group) {
        boolean empty = true;
        Connection conn = null;
        try {
            log.debug((Object)"checking to see if user is in group before attempting to delete");
            conn = DatabaseService.getInstance().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("SELECT * FROM specifyuser_spprincipal WHERE SpecifyUserID=? AND SpPrincipalID=?");
            pstmt.setString(1, "" + user.getId());
            pstmt.setString(2, "" + group.getId());
            log.debug((Object)("executing: " + pstmt.toString()));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                empty = false;
            }
            if (empty) {
                log.debug((Object)("User [" + user.getName() + "] does not belong to group [" + group.getName() + "]"));
            } else {
                log.debug((Object)("User [" + user.getName() + "]  belongs to group [" + group.getName() + "]"));
            }
            boolean bl = !empty;
            return bl;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
            log.error((Object)("Exception caught: " + e));
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
                    log.error((Object)("Exception caught: " + e.toString()));
                    e.printStackTrace();
                }
            }
        }
        return empty;
    }

    public static boolean removeUserFromGroups(SpecifyUser user, SpPrincipal group) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        String qStr = "DELETE FROM specifyuser_spprincipal WHERE SpecifyUserID = " + user.getId() + " AND SpPrincipalID=" + group.getId();
        session.createQuery(qStr, false).executeUpdate();
        session.close();
        return true;
    }

    public static boolean addUserGroup(SpPrincipal group) {
        Connection conn = null;
        String sql = "INSERT INTO spprincipal (Name, ClassName) VALUES(?,?)";
        PreparedStatement pstmt = null;
        try {
            conn = DatabaseService.getInstance().getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, group.getName());
            pstmt.setString(2, group.getClass().getName());
            boolean bl = pstmt.executeUpdate() > 0;
            return bl;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
            log.error((Object)("Executing sql" + pstmt.toString()));
            log.error((Object)("Exception caught: " + e));
            return false;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
                    e.printStackTrace();
                }
            }
        }
    }

    public static void removeUserGroup(SpPrincipal group) throws SQLException {
        Connection conn = null;
        try {
            try {
                conn = DatabaseService.getInstance().getConnection();
                PreparedStatement pstmtGrp = conn.prepareStatement("DELETE FROM specifyuser_spprincipal WHERE SpPrincipalID=?");
                pstmtGrp.setString(1, "" + group.getId());
                pstmtGrp.executeUpdate();
                PreparedStatement pstmt = conn.prepareStatement("DELETE FROM spprincipal WHERE SpPrincipalID=?");
                pstmt.setString(1, "" + group.getId());
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static boolean removeUserFromGroup(SpecifyUser user, SpPrincipal group) {
        Connection conn = null;
        try {
            conn = DatabaseService.getInstance().getConnection();
            PreparedStatement pstmt = conn.prepareStatement("DELETE FROM specifyuser_spprincipal WHERE SpecifyUserID=? AND SpPrincipalID=?");
            pstmt.setString(1, "" + user.getId());
            pstmt.setString(2, "" + group.getId());
            int res = pstmt.executeUpdate();
            boolean bl = res > 0;
            return bl;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
            log.error((Object)("addToUserGroup - " + e));
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(UserPrincipalHibernateService.class, e);
                    log.error((Object)("Exception caught: " + e.toString()));
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

