/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.policy;

import edu.ku.brc.af.auth.JaasContext;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.util.Pair;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class DatabaseService {
    protected static final Logger log = Logger.getLogger(DatabaseService.class);
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    public static Timestamp now = new Timestamp(System.currentTimeMillis());
    public static String nowStr = dateFormatter.format(now);
    private static boolean debug = false;
    private static DatabaseService INSTANCE = new DatabaseService();

    private DatabaseService() {
    }

    public static Connection getAdminLevelConnection(String url, String driverClass) {
        Connection con = null;
        try {
            if (debug) {
                log.debug((Object)("getAdminLevelConnection - trying to connect with driver: " + driverClass));
            }
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatabaseService.class, e);
            log.error((Object)"getAdminLevelConnection - Could not connect to database, driverclass - ClassNotFoundException: ");
            log.error((Object)("getAdminLevelConnection - " + e.getMessage()));
        }
        try {
            if (debug) {
                log.debug((Object)("getAdminLevelConnection - Trying to connect to: " + url));
            }
            if (debug) {
                log.error((Object)"getAdminLevelConnection - Trying to connect with BUILT IN ADMIN LEVER USER ACCOUNT - need to address");
            }
            Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
            con = DriverManager.getConnection(url, (String)usernamePassword.first, (String)usernamePassword.second);
            if (debug) {
                log.debug((Object)"getAdminLevelConnection - connected!");
            }
            return con;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatabaseService.class, ex);
            log.error((Object)"getAdminLevelConnection - Exception: ");
            log.error((Object)("getAdminLevelConnection - " + ex.getMessage()));
            return null;
        }
    }

    public Connection getConnection() throws SQLException {
        if (debug) {
            log.debug((Object)"getConnection");
        }
        try {
            Class.forName(JaasContext.driver);
        }
        catch (ClassNotFoundException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DatabaseService.class, e);
            log.error((Object)"getConnection - Could not connect to database, driverclass - ClassNotFoundException: ");
            log.error((Object)("getConnection - " + e.getMessage()));
        }
        Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
        if (debug) {
            log.debug((Object)("getConnection -  url:" + JaasContext.url));
        }
        if (debug) {
            log.debug((Object)("getConnection -  embeddedSpecifyAppRootUser:" + (String)usernamePassword.first));
        }
        if (debug) {
            log.debug((Object)("getConnection -  embeddedSpecifyAppRootPwd:" + (String)usernamePassword.second));
        }
        try {
            Connection connection = DriverManager.getConnection(JaasContext.url, (String)usernamePassword.first, (String)usernamePassword.second);
            return connection;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static DatabaseService getInstance() {
        return INSTANCE;
    }
}

