/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.policy;

import edu.ku.brc.af.auth.specify.permission.BasicSpPermission;
import edu.ku.brc.af.auth.specify.permission.PermissionService;
import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.BasicPrincipal;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DatabasePolicy
extends Policy {
    protected static final Logger log = Logger.getLogger(DatabasePolicy.class);
    protected Date cacheExpirationTime;
    protected Map<Principal, Permissions> cachedPermissions = new HashMap<Principal, Permissions>();
    protected final int cacheExpirationInSeconds = 60;

    public DatabasePolicy() {
        this.cacheExpirationTime = new Date();
    }

    protected boolean isCacheValid(Principal principal) {
        boolean expired = this.cacheExpirationTime.before(new Date());
        if (expired) {
            this.cachedPermissions.clear();
            return false;
        }
        return this.cachedPermissions.get(principal) != null;
    }

    protected void resetCacheTimer() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        ((Calendar)cal).add(13, 60);
        this.cacheExpirationTime = cal.getTime();
    }

    public PermissionCollection getPermissions(Principal principal) {
        Permissions principalPermissions = this.cachedPermissions.get(principal);
        if (this.isCacheValid(principal) && principalPermissions != null) {
            return principalPermissions;
        }
        this.resetCacheTimer();
        principalPermissions = new Permissions();
        if (!(principal instanceof BasicPrincipal)) {
            return principalPermissions;
        }
        BasicPrincipal basicPrincipal = (BasicPrincipal)principal;
        List<Permission> perms = PermissionService.findPrincipalBasedPermissions(basicPrincipal.getId());
        if (perms != null) {
            for (Permission perm : perms) {
                principalPermissions.add(perm);
            }
        }
        this.cachedPermissions.put(principal, principalPermissions);
        return principalPermissions;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource arg0) {
        return null;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (!(permission instanceof BasicSpPermission)) {
            return true;
        }
        Principal[] principalArray = domain.getPrincipals();
        int n = principalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Principal principal = principalArray[n2];
            if (principal.getClass().equals(AdminPrincipal.class)) {
                return true;
            }
            PermissionCollection perms = this.getPermissions(principal);
            if (perms.implies(permission)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String toString(Principal[] principals) {
        if (principals == null || principals.length == 0) {
            return "DatabasePolicy <empty principals>";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("DatabasePolicy <");
        int i = 0;
        while (i < principals.length) {
            Principal p = principals[i];
            buf.append("(class=");
            buf.append(p.getClass().getName());
            buf.append(", name=");
            buf.append(p.getName());
            buf.append(")");
            if (i < principals.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(">");
        return buf.toString();
    }

    @Override
    public void refresh() {
        this.cachedPermissions = null;
    }
}

