/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.policy;

import edu.ku.brc.af.auth.specify.policy.DatabaseService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.log4j.Logger;

public class DatabaseConfiguration
extends Configuration {
    private static final Logger log = Logger.getLogger(DatabaseConfiguration.class);
    private static DatabaseConfiguration spDbConfig;
    private static String url;
    private static String driver;

    static {
        url = "";
        driver = "";
    }

    public DatabaseConfiguration(String url, String driver) {
        log.debug((Object)("url: " + url));
        log.debug((Object)("driver: " + driver));
        DatabaseConfiguration.url = url;
        DatabaseConfiguration.driver = driver;
    }

    static void init(String urlArg, String driverArg) {
        log.debug((Object)"init");
        spDbConfig = new DatabaseConfiguration(urlArg, driverArg);
        Configuration.setConfiguration(spDbConfig);
    }

    public boolean deleteAppConfigurationEntry(String appName, String loginModuleName, String urlArg, String driverArg) throws SQLException {
        log.debug((Object)("deleteAppConfigurationEntry: appName[" + appName + "] loginModuleName[" + loginModuleName + "] url[" + urlArg + "] driver[" + driverArg + "]"));
        Connection conn = null;
        try {
            conn = DatabaseService.getAdminLevelConnection(urlArg, driverArg);
            String sql = "DELETE FROM sp_app_configuration WHERE appName='" + appName + "' AND loginModuleClass='" + loginModuleName + "'";
            log.debug((Object)("executing SQL: " + sql));
            PreparedStatement pstmt = conn.prepareStatement(sql);
            boolean bl = pstmt.executeUpdate() > 0;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void addAppConfigurationEntry(String appName, AppConfigurationEntry entry, String urlArg, String driverArg) throws SQLException {
        log.debug((Object)("addAppConfigurationEntry: appName[" + appName + "] entry.getLoginModuleName()[" + entry.getLoginModuleName() + "] url[" + urlArg + "] driver[" + driverArg + "]"));
        Connection conn = null;
        try {
            conn = DatabaseService.getAdminLevelConnection(urlArg, driverArg);
            String sql = "INSERT INTO sp_app_configuration VALUES ('" + appName + "', '" + entry.getLoginModuleName() + "', '" + this.controlFlagString(entry.getControlFlag()) + "')";
            log.debug((Object)("executing SQL: " + sql));
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String controlFlagString(AppConfigurationEntry.LoginModuleControlFlag flag) {
        if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(flag)) {
            return "required";
        }
        if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag)) {
            return "requisite";
        }
        if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag)) {
            return "sufficient";
        }
        if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.equals(flag)) {
            return "optional";
        }
        log.warn((Object)("resolveControlFlag is an unknown LoginModuleControlFlag. Returning LoginModuleControlFlag.OPTIONAL; flagpassed[" + flag + "]"));
        return "OPTIONAL";
    }

    public static DatabaseConfiguration getDbConfiguration() {
        return spDbConfig;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        log.debug((Object)("getAppConfigurationEntry: appName[" + applicationName + "]"));
        log.debug((Object)("getAppConfigurationEntry: url[" + url + "]"));
        log.debug((Object)("getAppConfigurationEntry: driver[" + driver + "]"));
        if (applicationName == null) {
            log.error((Object)"getAppConfigurationEntry: Throwing Null pointer exception: applicationName passed in was null.");
            throw new NullPointerException("applicationName passed in was null.");
        }
        Connection conn = null;
        try {
            conn = DatabaseService.getAdminLevelConnection(url, driver);
            String sql = "SELECT loginModuleClass, controlFlag FROM app_configuration WHERE appName='" + applicationName + "'";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, applicationName);
            ResultSet rs = pstmt.executeQuery();
            ArrayList<AppConfigurationEntry> entries = new ArrayList<AppConfigurationEntry>();
            while (rs.next()) {
                String loginModuleClass = rs.getString("loginModuleClass");
                String controlFlagValue = rs.getString("controlFlag");
                AppConfigurationEntry.LoginModuleControlFlag controlFlag = this.resolveControlFlag(controlFlagValue);
                AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClass, controlFlag, new HashMap());
                entries.add(entry);
            }
            if (entries.isEmpty()) {
                log.debug((Object)("getAppConfigurationEntry()  No AppConfigurationEntrys found for applicationName: " + applicationName));
            }
            AppConfigurationEntry[] appConfigurationEntryArray = entries.toArray(new AppConfigurationEntry[entries.size()]);
            return appConfigurationEntryArray;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(DatabaseConfiguration.class, e);
            log.error((Object)("getAppConfigurationEntry: SQLException retrieving for applicationName=" + applicationName), (Throwable)e);
            throw new RuntimeException("SQLException retrieving for applicationName=" + applicationName, e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(DatabaseConfiguration.class, e);
                    log.error((Object)("getAppConfigurationEntry() Couldn't close connection. SQLException: " + e.getSQLState()));
                }
            }
        }
    }

    @Override
    public void refresh() {
    }

    public static void main(String[] args) {
    }

    public AppConfigurationEntry.LoginModuleControlFlag resolveControlFlag(String name) {
        if (name == null) {
            throw new NullPointerException("control flag name passed in is null.");
        }
        String uppedName = name.toUpperCase(Locale.US);
        if ("REQUIRED".equals(uppedName)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("REQUISITE".equals(uppedName)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("SUFFICIENT".equals(uppedName)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("OPTIONAL".equals(uppedName)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        log.error((Object)("resolveControlFlag (up-cased) is an unknown String controlFlag. Returning OPTIONAL flag[" + uppedName + "]"));
        return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
    }
}

