/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.policy;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class CompositePolicy
extends Policy {
    protected static final Logger log = Logger.getLogger(CompositePolicy.class);
    private List<Policy> policies = new ArrayList<Policy>();

    public CompositePolicy(List<Policy> policies) {
        this.policies = policies;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        for (Policy policy : this.policies) {
            PermissionCollection permCol = policy.getPermissions(domain);
            Enumeration<Permission> en = permCol.elements();
            while (en.hasMoreElements()) {
                perms.add(en.nextElement());
            }
        }
        return perms;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        log.debug((Object)("Permission=" + permission));
        for (Policy p : this.policies) {
            if (!p.implies(domain, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions perms = new Permissions();
        for (Policy p : this.policies) {
            PermissionCollection permsCol = p.getPermissions(codesource);
            Enumeration<Permission> en = permsCol.elements();
            while (en.hasMoreElements()) {
                perms.add(en.nextElement());
            }
        }
        return perms;
    }

    @Override
    public void refresh() {
        for (Policy p : this.policies) {
            p.refresh();
        }
    }
}

