/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.permission;

import edu.ku.brc.af.auth.specify.policy.DatabaseService;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.SpPermission;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class PermissionService {
    protected static final Logger log = Logger.getLogger(PermissionService.class);
    private static boolean debug = false;
    private static final Certificate[] EMPTY_CERTS = new Certificate[0];
    private static final Class<?>[] ZERO_ARGS = new Class[0];
    private static final Object[] ZERO_OBJS = new Object[0];
    private static final Class<?>[] ONE_STRING_ARG = new Class[]{String.class};
    private static final Class<?>[] TWO_STRING_ARGS = new Class[]{String.class, String.class};

    public static void removePermission(Integer id) {
        PermissionService.removePrincipalPermissions(Collections.singleton(id));
    }

    public static void removePrincipalPermissions(Set<?> ids) {
        Connection conn = null;
        Statement tiePstmt = null;
        Statement permPstmt = null;
        try {
            try {
                conn = DatabaseService.getInstance().getConnection();
                String sql = "DELETE FROM spprincipal_sppermission WHERE SpPermissionID = ?";
                tiePstmt = conn.prepareStatement(sql);
                permPstmt = conn.prepareStatement("DELETE FROM sppermission WHERE SpPermissionID= ?");
                for (Integer id : ids) {
                    tiePstmt.setString(1, "" + id);
                    permPstmt.setString(1, "" + id);
                    tiePstmt.executeUpdate();
                    permPstmt.executeUpdate();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (tiePstmt != null) {
                        tiePstmt.close();
                    }
                    if (permPstmt != null) {
                        permPstmt.close();
                    }
                }
                catch (SQLException e2) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e2);
                    log.error((Object)("Exception caught: " + e2.toString()));
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (tiePstmt != null) {
                    tiePstmt.close();
                }
                if (permPstmt != null) {
                    permPstmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
    }

    public static List<Permission> findPrincipalPermissions(Set<Integer> principalIds) {
        if (debug) {
            log.debug((Object)"findPrincipalPermissions");
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Integer principalId : principalIds) {
            if (debug) {
                log.debug((Object)("findPrincipalPermissions - principalID" + principalId));
            }
            permissions.addAll(PermissionService.findPrincipalBasedPermissions(principalId));
        }
        return permissions;
    }

    private static List<SpPrincipal> getGroupPrincipals(SpecifyUser user) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            List<SpPrincipal> principals;
            List<SpPrincipal> list = principals = session.getDataList("SELECT pc FROM SpPrincipal as pc INNER JOIN pc.specifyUsers as user WHERE groupSubClass = 'edu.ku.brc.af.auth.specify.principal.GroupPrincipal' AND user.id = " + user.getId());
            return list;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PermissionService.class, e);
            e.printStackTrace();
        }
        finally {
            session.close();
        }
        return null;
    }

    public static Hashtable<String, SpPermission> getOverridingPermissions(SpecifyUser user) {
        Hashtable<String, SpPermission> hash = new Hashtable<String, SpPermission>();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        List<SpPrincipal> principals = PermissionService.getGroupPrincipals(user);
        String strSet = PermissionService.getPrincipalSet(principals);
        try {
            try {
                List<?> perms = session.getDataList("SELECT pm FROM SpPermission as pm INNER JOIN FETCH pm.principals as pc WHERE pc.id in " + strSet);
                for (Object permObj : perms) {
                    SpPermission perm = (SpPermission)permObj;
                    hash.put(perm.getName(), perm);
                    log.debug((Object)(String.valueOf(perm.getName()) + "  " + perm.getActions()));
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                e.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
        return hash;
    }

    private static String getPrincipalSet(List<SpPrincipal> principals) {
        StringBuffer inClause = new StringBuffer();
        inClause.append("(");
        boolean first = true;
        for (SpPrincipal spPrincipal : principals) {
            if (!first) {
                inClause.append(", ");
            } else {
                first = false;
            }
            inClause.append(spPrincipal.getId());
        }
        inClause.append(")");
        return inClause.toString();
    }

    public static Hashtable<String, SpPermission> getExistingPermissions(Integer principalId) {
        Hashtable<String, SpPermission> hash = new Hashtable<String, SpPermission>();
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                List<?> perms = session.getDataList("SELECT pm FROM SpPermission as pm INNER JOIN FETCH pm.principals as pc WHERE pc.id = " + principalId);
                for (Object permObj : perms) {
                    SpPermission perm = (SpPermission)permObj;
                    hash.put(perm.getName(), perm);
                }
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                e.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return hash;
    }

    public static List<Permission> findPrincipalBasedPermissions(Integer principalId) {
        if (debug) {
            log.debug((Object)("findPrincipalBasedPermissions - principalId: " + principalId));
        }
        ArrayList<Permission> perms = new ArrayList<Permission>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                Collection collection = AppContextMgr.getInstance().getClassObject(Collection.class);
                conn = DatabaseService.getInstance().getConnection();
                String sql = String.format("SELECT pm.SpPermissionID, pm.PermissionClass, pm.Name, pm.Actions, p.userGroupScopeID FROM sppermission AS pm Inner Join spprincipal_sppermission AS sp ON pm.SpPermissionID = sp.SpPermissionID Inner Join spprincipal AS p ON sp.SpPrincipalID = p.SpPrincipalID WHERE p.SpPrincipalID = %d AND p.userGroupScopeID = %d", principalId, collection.getId());
                if (debug) {
                    log.debug((Object)("sql: " + sql));
                }
                pstmt = conn.prepareStatement(sql);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    Permission perm;
                    Integer id = rs.getInt("SpPermissionID");
                    String clazzStr = rs.getString("PermissionClass");
                    String name = rs.getString("Name");
                    String actions = rs.getString("Actions");
                    if (debug) {
                        log.debug((Object)("findPermissions()Permission found:  id={" + id + "}, class={" + clazzStr + "}, name={" + name + "}, actions={" + actions + "}"));
                    }
                    if ((perm = PermissionService.createPrincipalBasedPermission(id, clazzStr, name, actions)) == null) continue;
                    perms.add(perm);
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e2) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e2);
                    log.error((Object)("Exception caught: " + e2.toString()));
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
        return perms;
    }

    private static Permission createPrincipalBasedPermission(Integer id, String clazzStr, String name, String actions) {
        Permission perm;
        block17: {
            if (debug) {
                log.debug((Object)("createPrincipalBasedPermission - [" + clazzStr + "] [" + name + "] [" + actions + "]"));
            }
            perm = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzStr);
            }
            catch (ClassNotFoundException e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("ClassNotFoundException: " + e.getMessage()));
            }
            if (clazz == null) {
                perm = new UnresolvedPermission(clazzStr, name, actions, EMPTY_CERTS);
            } else if (clazz.equals(FilePermission.class)) {
                perm = new FilePermission(name, actions);
            } else if (Permission.class.isAssignableFrom(clazz)) {
                try {
                    if (name == null && actions == null) {
                        Constructor<?> con = clazz.getConstructor(ZERO_ARGS);
                        perm = (Permission)con.newInstance(ZERO_OBJS);
                        break block17;
                    }
                    if (actions == null) {
                        Constructor<?> con = clazz.getConstructor(ONE_STRING_ARG);
                        Object[] args = new String[]{name};
                        perm = (Permission)con.newInstance(args);
                        break block17;
                    }
                    if (name != null && actions != null) {
                        Constructor<?> con = clazz.getConstructor(TWO_STRING_ARGS);
                        Object[] args = new String[]{name, actions};
                        perm = (Permission)con.newInstance(args);
                        break block17;
                    }
                    log.error((Object)("findPermissions() No suitable constructor (default, one String, or two String args) found to create Permission of type [" + clazz + "]. Skipping"));
                }
                catch (NoSuchMethodException e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                    log.error((Object)("findPermissions() Constructor for Permission with Id {" + id + "}of {" + clazzStr + "} threw Exception {" + e + "}. Skipping."));
                }
                catch (InstantiationException e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                    log.error((Object)("findPermissions() Constructor for Permission with Id {" + id + "}of {" + clazz + "} threw Exception {" + e + "}. Skipping."));
                }
                catch (IllegalAccessException e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                    log.error((Object)("findPermissions() Constructor for Permission with Id {" + id + "}of {" + clazz + "} threw Exception {" + e + "}. Skipping."));
                }
                catch (InvocationTargetException e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                    log.error((Object)("findPermissions() Constructor for Permission with Id {" + id + "}of {" + clazz + "} threw Exception {" + e + "}. Skipping."));
                }
            } else {
                log.error((Object)("findPermissions() Permission with Id {" + id + "}has unsupported type of {" + clazz + "}"));
            }
        }
        return perm;
    }

    private static boolean joinSpPrincipalPermission(SpPrincipal sp, Permission permission) {
        if (debug) {
            log.debug((Object)"joinSpPrincipalPermission");
        }
        Connection conn = null;
        Statement pstmt = null;
        Integer principalId = sp.getId();
        Integer permissionId = PermissionService.getPermissionsId(permission);
        if (principalId == null || permissionId == null) {
            return false;
        }
        if (!PermissionService.doesSpPrincipalHavePermission(sp, permission)) {
            try {
                conn = DatabaseService.getInstance().getConnection();
                String query = "INSERT INTO spprincipal_sppermission VALUES (" + principalId + ", " + permissionId + ")";
                pstmt = conn.prepareStatement(query);
                if (debug) {
                    log.debug((Object)("joinSpPrincipalPermission - executing: " + query));
                }
                pstmt.executeUpdate();
                conn.close();
                return true;
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e);
                    log.error((Object)("Exception caught: " + e.toString()));
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static boolean doesSpPrincipalHavePermission(SpPrincipal sp, Permission permission) {
        if (debug) {
            log.debug((Object)"doesSpPrincipalHavePermission");
        }
        boolean isPermissionGranted = false;
        Connection conn = null;
        Statement pstmt = null;
        Integer principalId = sp.getId();
        Integer permissionId = PermissionService.getPermissionsId(permission);
        if (principalId == null || permissionId == null) {
            return false;
        }
        try {
            try {
                conn = DatabaseService.getInstance().getConnection();
                String query = "SELECT count(*) from spprincipal_sppermission WHERE spprincipal_sppermission.SpPrincipalID=" + principalId + " " + "AND spprincipal_sppermission.SpPermissionID=" + permissionId + " ";
                pstmt = conn.prepareStatement(query);
                if (debug) {
                    log.debug((Object)("doesSpPrincipalHavePermission - executing: " + query));
                }
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = rs.getInt(1);
                    if (i <= 0) continue;
                    isPermissionGranted = true;
                    if (!debug) continue;
                    log.debug((Object)"doesSpPrincipalHavePermission -   permission is already granted");
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e2) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e2);
                    log.error((Object)("Exception caught: " + e2.toString()));
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
        return isPermissionGranted;
    }

    private static Integer getPermissionsId(Permission permission) {
        if (debug) {
            log.debug((Object)"getPermissionsId");
        }
        Connection conn = null;
        Statement pstmt = null;
        try {
            ResultSet rs;
            conn = DatabaseService.getInstance().getConnection();
            String query = "SELECT sppermission.SpPermissionID FROM sppermission WHERE sppermission.Actions='" + permission.getActions() + "' " + "AND sppermission.Name='" + permission.getName() + "' " + "AND sppermission.PermissionClass='" + permission.getClass().getCanonicalName() + "' ";
            pstmt = conn.prepareStatement(BasicSQLUtils.escapeStringLiterals(query));
            if (debug) {
                log.debug((Object)("executing: " + query));
            }
            if ((rs = pstmt.executeQuery()).next()) {
                Integer id = rs.getInt("SpPermissionID");
                if (debug) {
                    log.debug((Object)("getPermissionsId() found: sppermission.SpPermissionID=" + id));
                }
                Integer n = id;
                return n;
            }
            return null;
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(PermissionService.class, e);
            log.error((Object)("Exception caught: " + e));
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void giveSpPrincipalPermission(SpPrincipal sp, Permission permission) {
        PermissionService.createPermission(permission);
        PermissionService.joinSpPrincipalPermission(sp, permission);
    }

    private static void createPermission(Permission permission) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                conn = DatabaseService.getInstance().getConnection();
                pstmt = conn.prepareStatement("INSERT INTO sppermission (Actions, Name, PermissionClass) VALUES (?, ?, ?)");
                pstmt.setString(1, permission.getActions());
                pstmt.setString(2, permission.getName());
                pstmt.setString(3, permission.getClass().getName());
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e));
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(PermissionService.class, e2);
                    log.error((Object)("Exception caught: " + e2.toString()));
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
    }

    public static SpPrincipal getSpPrincipalByName(String name) {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        SpPrincipal principal = null;
        try {
            List<SpPrincipal> lister = session.getDataList(SpPrincipal.class, "name", name);
            if (lister.size() == 0) {
                return null;
            }
            try {
                principal = lister.get(0);
            }
            catch (Exception e1) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PermissionService.class, e1);
                log.error((Object)e1);
                e1.printStackTrace();
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return principal;
    }

    public static boolean runCheckPermssion(Subject s, final Permission perm) {
        if (debug) {
            log.debug((Object)String.format("runCheckPermssion - calling doAsPrivileged to check if subject has permission [%s] [%s]", perm.getName(), perm.getActions()));
        }
        try {
            Subject.doAsPrivileged(s, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AccessController.checkPermission(perm);
                    if (debug) {
                        log.debug((Object)"runCheckPermssion - permission found, returning true");
                    }
                    return true;
                }
            }, null);
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (Exception ee) {
            log.error((Object)"runCheckPermssion - exception caught");
            ee.printStackTrace();
            log.error((Object)ee.getCause());
            log.error((Object)ee.getMessage());
        }
        if (debug) {
            log.debug((Object)"runCheckPermssion - permission NOT granted");
        }
        return false;
    }
}

