/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.permission;

import edu.ku.brc.af.auth.JaasContext;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.Permission;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class PermissionHelper {
    private static final Logger log = Logger.getLogger(PermissionHelper.class);

    public static void invokeSubjectPermCall(final Permission myPerm) {
        Subject subject = JaasContext.getGlobalSubject();
        boolean allowed = true;
        try {
            Subject.doAsPrivileged(subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(myPerm);
                    }
                    return null;
                }
            }, null);
        }
        catch (SecurityException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PermissionHelper.class, e);
            allowed = false;
        }
        if (allowed) {
            log.debug((Object)"permission was granted");
        } else {
            log.error((Object)("permission was denied" + myPerm.toString()));
            System.exit(0);
        }
    }
}

