/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify.module;

import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.specify.credential.UsernameCredential;
import edu.ku.brc.af.auth.specify.principal.AdminPrincipal;
import edu.ku.brc.af.auth.specify.principal.GroupPrincipal;
import edu.ku.brc.af.auth.specify.principal.UserPrincipal;
import edu.ku.brc.af.auth.specify.principal.UserPrincipalSQLService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public class SpDBLoginModule
implements LoginModule {
    protected static final Logger log = Logger.getLogger(SpDBLoginModule.class);
    private CallbackHandler callbackHandler;
    private Subject subject;
    private String username;
    private String password;
    private String url;
    private String driverClass;
    private String dbUserName;
    private String dbPwd;
    boolean authenticated = false;

    @Override
    public void initialize(Subject subjectArg, CallbackHandler callbackHandlerArg, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandlerArg;
        this.subject = subjectArg;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler provided");
        }
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new TextInputCallback("Url:"), new TextInputCallback("Driver:"), new TextInputCallback("DBUserName:"), new TextInputCallback("DBPwd:")};
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            this.password = new String(((PasswordCallback)callbacks[1]).getPassword());
            this.url = new String(((TextInputCallback)callbacks[2]).getText());
            this.driverClass = new String(((TextInputCallback)callbacks[3]).getText());
            this.dbUserName = new String(((TextInputCallback)callbacks[4]).getText());
            this.dbPwd = new String(((TextInputCallback)callbacks[5]).getText());
            this.authenticated = SecurityMgr.getInstance().authenticateDB(this.username, this.password, this.driverClass, this.url, this.dbUserName, this.dbPwd);
            int i = 0;
            while (i < callbacks.length) {
                callbacks[i] = null;
                ++i;
            }
            if (!this.authenticated) {
                this.abort();
            }
            return this.authenticated;
        }
        catch (LoginException ex) {
            log.error((Object)("LoginException" + ex.getMessage()));
            this.authenticated = false;
            ex.printStackTrace();
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpDBLoginModule.class, ex);
            log.error((Object)("Exception" + ex.getMessage()));
            ex.printStackTrace();
            throw new LoginException(ex.getMessage());
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authenticated) {
            log.debug((Object)"user was not authenticated");
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is Readonly");
        }
        try {
            Set<SpPrincipal> groups = UserPrincipalSQLService.getUsersGroupsByUsername(this.username);
            for (SpPrincipal ug : groups) {
                String s = "class " + ug.getGroupSubClass();
                if (s == null) continue;
                if (s.equals(AdminPrincipal.class.toString())) {
                    AdminPrincipal adminUser = new AdminPrincipal(ug.getId(), this.username);
                    this.subject.getPrincipals().add(adminUser);
                    continue;
                }
                if (s.equals(GroupPrincipal.class.toString())) {
                    GroupPrincipal groupPrincipal = new GroupPrincipal(ug.getId(), this.username);
                    this.subject.getPrincipals().add(groupPrincipal);
                    continue;
                }
                if (!s.equals(UserPrincipal.class.toString())) continue;
                UserPrincipal userPrincipal = new UserPrincipal(ug.getId(), this.username);
                this.subject.getPrincipals().add(userPrincipal);
            }
            UsernameCredential cred = new UsernameCredential(this.username);
            this.subject.getPublicCredentials().add(cred);
            return true;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpDBLoginModule.class, ex);
            log.error((Object)("Specify exception occurred" + ex.toString()));
            ex.printStackTrace();
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            return false;
        }
        for (SpPrincipal p : this.subject.getPrincipals(SpPrincipal.class)) {
            this.subject.getPrincipals().remove(p);
        }
        for (SpPrincipal c : this.subject.getPublicCredentials(SpPrincipal.class)) {
            this.subject.getPrincipals().remove(c);
        }
        this.cleanState();
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.cleanState();
        this.logout();
        return true;
    }

    public void cleanState() {
        this.username = null;
        this.password = null;
        this.url = null;
        this.driverClass = null;
        this.authenticated = false;
    }
}

