/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth.specify;

import edu.ku.brc.af.auth.JaasContext;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.specify.permission.BasicSpPermission;
import edu.ku.brc.af.auth.specify.permission.PermissionService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.ui.UIHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpecifySecurityMgr
extends SecurityMgr {
    private static final Logger log = Logger.getLogger(SpecifySecurityMgr.class);
    protected static boolean doingLocal = false;
    protected static boolean debug = false;
    protected boolean domFound = false;
    protected String localFileName = "backstop" + File.separator + "security.xml";

    public static void setLocalFileName(String localFileName) {
        ((SpecifySecurityMgr)SpecifySecurityMgr.getInstance()).localFileName = localFileName;
    }

    public static String getLocalFileName() {
        return ((SpecifySecurityMgr)SpecifySecurityMgr.getInstance()).localFileName;
    }

    public static void setDoingLocal(boolean doLocal) {
        doingLocal = doLocal;
    }

    @Override
    public boolean authenticateDB(String user, String pass, String driverClass, String url, String dbUserName, String dbPwd) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        boolean passwordMatch = false;
        try {
            try {
                Class.forName(driverClass);
                conn = DriverManager.getConnection(url, dbUserName, dbPwd);
                String query = "SELECT * FROM specifyuser where name='" + user + "'";
                stmt = conn.createStatement();
                ResultSet result = stmt.executeQuery(query);
                String dbPassword = null;
                if (result.next()) {
                    if (!result.isFirst()) {
                        throw new LoginException("authenticateDB - Ambiguous user (located more than once): " + user);
                    }
                    dbPassword = result.getString(result.findColumn("Password"));
                    if (StringUtils.isNotEmpty((String)dbPassword) && StringUtils.isAlphanumeric((String)dbPassword) && UIHelper.isAllCaps(dbPassword) && dbPassword.length() > 20) {
                        dbPassword = Encryption.decrypt(dbPassword, pass);
                    }
                }
                if (pass != null && dbPassword != null && pass.equals(dbPassword)) {
                    passwordMatch = true;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifySecurityMgr.class, e);
                log.error((Object)"authenticateDB - Could not connect to database, driverclass - ClassNotFoundException: ");
                log.error((Object)e.getMessage());
                throw new LoginException("authenticateDB -  Database driver class not found: " + driverClass);
            }
            catch (SQLException ex) {
                if (debug) {
                    log.error((Object)("authenticateDB - SQLException: " + ex.toString()));
                }
                if (debug) {
                    log.error((Object)("authenticateDB - " + ex.getMessage()));
                }
                throw new LoginException("authenticateDB - SQLException: " + ex.getMessage());
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(SpecifySecurityMgr.class, e);
                log.error((Object)("Exception caught: " + e.toString()));
                e.printStackTrace();
            }
        }
        return passwordMatch;
    }

    @Override
    public void grantPermission(Subject currentSubject, Principal principalToMatchTo, Permission perm) {
        log.debug((Object)"grantPermission");
        if (currentSubject == null) {
            log.error((Object)"grantPermission - subject is null - cannot grant permission");
            return;
        }
        if (perm == null) {
            log.error((Object)"grantPermission - permission is null - cannot grant permission");
            return;
        }
        Set<Principal> p = currentSubject.getPrincipals();
        if (p == null) {
            log.error((Object)"grantPermission - there are no principals associated with this user - cannot grant permission");
            return;
        }
        for (Principal principal : p) {
            String principalClassName = principal.getClass().getCanonicalName();
            if (!principalClassName.equals(SpPrincipal.class.getCanonicalName())) continue;
            SpPrincipal spp = (SpPrincipal)principal;
            String principalType = spp.getGroupSubClass();
            String principalName = spp.getName();
            SpPrincipal mySpPrincipal = PermissionService.getSpPrincipalByName(principalName);
            if (principalToMatchTo == null) {
                PermissionService.giveSpPrincipalPermission(mySpPrincipal, perm);
                continue;
            }
            if (!principalType.equals(principalToMatchTo.getClass().getCanonicalName())) continue;
            PermissionService.giveSpPrincipalPermission(mySpPrincipal, perm);
        }
    }

    @Override
    public boolean checkPermission(String name, String actions) {
        return this.checkPermission(BasicSpPermission.class, name, actions);
    }

    public int getPermissionOptions(String name) {
        return this.getPermissionOptions(BasicSpPermission.class, name);
    }

    @Override
    public PermissionSettings getPermission(String name) {
        return new PermissionSettings(this.getPermissionOptions(name));
    }

    protected boolean checkPermission(Class<?> permissionClass, String name, String actions) {
        if (!BasicSpPermission.class.isAssignableFrom(permissionClass)) {
            throw new SecurityException(String.valueOf(permissionClass.getName()) + " class is not part of Specify permission hierarchy.");
        }
        Constructor<?> constructor = null;
        BasicSpPermission perm = null;
        try {
            constructor = permissionClass.getConstructor(String.class, String.class);
            perm = (BasicSpPermission)constructor.newInstance(name, actions);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifySecurityMgr.class, e);
            throw new RuntimeException(e);
        }
        return this.checkPermission(perm);
    }

    protected int getPermissionOptions(Class<?> permissionClass, String name) {
        int n;
        if (!BasicSpPermission.class.isAssignableFrom(permissionClass)) {
            throw new SecurityException(String.valueOf(permissionClass.getName()) + " class is not part of Specify permission hierarchy.");
        }
        int options = 0;
        Constructor<?> constructor = null;
        try {
            constructor = permissionClass.getConstructor(String.class, String.class);
            if (debug) {
                log.debug((Object)("******************* Can View: " + name + " - " + this.checkPermission((BasicSpPermission)constructor.newInstance(name, "view"))));
                log.debug((Object)("******************* Can Mod : " + name + " - " + this.checkPermission((BasicSpPermission)constructor.newInstance(name, "modify"))));
                log.debug((Object)("******************* Can Del : " + name + " - " + this.checkPermission((BasicSpPermission)constructor.newInstance(name, "delete"))));
                log.debug((Object)("******************* Can Add : " + name + " - " + this.checkPermission((BasicSpPermission)constructor.newInstance(name, "add"))));
            }
            options |= this.checkPermission((BasicSpPermission)constructor.newInstance(name, "modify")) ? 2 : 0;
            options |= this.checkPermission((BasicSpPermission)constructor.newInstance(name, "view")) ? 1 : 0;
            options |= this.checkPermission((BasicSpPermission)constructor.newInstance(name, "add")) ? 8 : 0;
            n = this.checkPermission((BasicSpPermission)constructor.newInstance(name, "delete")) ? 4 : 0;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifySecurityMgr.class, e);
            throw new RuntimeException(e);
        }
        return options |= n;
    }

    public boolean checkPermission(BasicSpPermission myPerm) {
        Subject currentSubject = JaasContext.getGlobalSubject();
        if (currentSubject != null && myPerm != null) {
            return PermissionService.runCheckPermssion(currentSubject, myPerm);
        }
        log.error((Object)"doesCurrentUserHavePermission - either current subject or permission passed is null, should not happen");
        return false;
    }
}

