/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.PasswordStrengthUI;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.ValPasswordField;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class UserAndMasterPasswordMgr {
    public static final String factoryName = "edu.ku.brc.af.auth.UserAndMasterPasswordMgr";
    public static final String MASTER_LOCAL = "master.islocal";
    public static final String MASTER_PATH = "master.path";
    private static UserAndMasterPasswordMgr instance = null;
    private char currEcho;
    private String showPwdLabel = UIRegistry.getResourceString("SHOW_PASSWORD");
    private String hidePwdLabel = UIRegistry.getResourceString("HIDE_PASSWORD");
    private Pair<String, String> dbUsernameAndPassword = null;
    private String usersUserName = null;
    private String usersPassword = null;
    private String databaseName = null;

    protected UserAndMasterPasswordMgr() {
    }

    public String getIsLocalPrefPath(boolean includeDBName) {
        return UserAndMasterPasswordMgr.getIsLocalPrefPath(this.usersUserName, this.databaseName, includeDBName);
    }

    public static String getIsLocalPrefPath(String usrName, String dbName, boolean includeDBName) {
        return String.valueOf(StringUtils.isNotEmpty((String)dbName) && includeDBName ? String.valueOf(dbName) + '_' : "") + usrName + "_" + MASTER_LOCAL;
    }

    public String getMasterPrefPath(boolean includeDBName) {
        return UserAndMasterPasswordMgr.getMasterPrefPath(this.usersUserName, this.databaseName, includeDBName);
    }

    public static String getMasterPrefPath(String usrName, String dbName, boolean includeDBName) {
        return String.valueOf(StringUtils.isNotEmpty((String)dbName) && includeDBName ? String.valueOf(dbName) + '_' : "") + usrName + "_" + MASTER_PATH;
    }

    public boolean editMasterInfo(String username, String dbName, boolean askForCredentials) {
        String uNameCached = username != null ? username : this.usersUserName;
        this.usersUserName = username;
        Boolean isLocal = AppPreferences.getLocalPrefs().getBoolean(this.getIsLocalPrefPath(true), null);
        if (isLocal == null) {
            isLocal = AppPreferences.getLocalPrefs().getBoolean(this.getIsLocalPrefPath(false), null);
        } else {
            AppPreferences.getLocalPrefs().remove(this.getIsLocalPrefPath(false));
        }
        String masterKey = AppPreferences.getLocalPrefs().get(this.getMasterPrefPath(true), null);
        if (StringUtils.isEmpty((String)masterKey)) {
            masterKey = AppPreferences.getLocalPrefs().get(this.getMasterPrefPath(false), null);
        } else {
            AppPreferences.getLocalPrefs().remove(this.getMasterPrefPath(false));
        }
        if (masterKey == null && askForCredentials && this.askToContForCredentials() == 1) {
            return false;
        }
        boolean isOK = this.askForInfo(isLocal, this.usersUserName, dbName, masterKey);
        if (StringUtils.isEmpty((String)this.usersUserName) && StringUtils.isNotEmpty((String)uNameCached)) {
            this.usersUserName = uNameCached;
        }
        return isOK;
    }

    public void set(String usersUserName, String usersPassword, String databaseName) {
        this.usersUserName = usersUserName;
        this.usersPassword = usersPassword;
        this.databaseName = databaseName;
        this.clear();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void clear() {
        this.dbUsernameAndPassword = null;
    }

    public boolean hasMasterUsernameAndPassword() {
        String masterKey;
        Boolean isLocal = AppPreferences.getLocalPrefs().getBoolean(this.getIsLocalPrefPath(true), null);
        if (isLocal == null) {
            isLocal = AppPreferences.getLocalPrefs().getBoolean(this.getIsLocalPrefPath(false), true);
        }
        if (isLocal.booleanValue() && StringUtils.isEmpty((String)(masterKey = AppPreferences.getLocalPrefs().get(this.getMasterPrefPath(true), null)))) {
            return AppPreferences.getLocalPrefs().get(this.getMasterPrefPath(false), null) != null;
        }
        return true;
    }

    public Pair<String, String> getUserNamePasswordForDB() {
        if (this.dbUsernameAndPassword == null && this.usersPassword != null) {
            this.dbUsernameAndPassword = this.getUserNamePasswordInternal();
        }
        return this.dbUsernameAndPassword;
    }

    protected int askToContForCredentials() {
        int userChoice = 1;
        Object[] options = new Object[]{UIRegistry.getResourceString("Continue"), UIRegistry.getResourceString("CANCEL")};
        UIRegistry.loadAndPushResourceBundle("masterusrpwd");
        userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("MISSING_CREDS", this.usersUserName), UIRegistry.getResourceString("MISSING_CREDS_TITLE"), 0, 3, null, options, options[0]);
        UIRegistry.popResourceBundle();
        return userChoice;
    }

    protected Pair<String, String> getUserNamePasswordInternal() {
        String masterKey;
        Pair<String, String> noUP = new Pair<String, String>("", "");
        Boolean isLocal = AppPreferences.getLocalPrefs().getBoolean(this.getIsLocalPrefPath(true), null);
        if (isLocal == null) {
            isLocal = AppPreferences.getLocalPrefs().getBoolean(this.getIsLocalPrefPath(false), null);
        }
        if (StringUtils.isEmpty((String)(masterKey = AppPreferences.getLocalPrefs().get(this.getMasterPrefPath(true), null)))) {
            masterKey = AppPreferences.getLocalPrefs().get(this.getMasterPrefPath(false), null);
        }
        if (isLocal == null || StringUtils.isEmpty((String)masterKey)) {
            if (this.askToContForCredentials() == 1) {
                return null;
            }
            if (!this.askForInfo(null, null, null, null)) {
                return noUP;
            }
        }
        if (StringUtils.isNotEmpty((String)masterKey)) {
            String keyStr;
            block15: {
                keyStr = null;
                if (isLocal.booleanValue()) {
                    try {
                        keyStr = Encryption.decrypt(masterKey, this.usersPassword);
                        if (keyStr == null) {
                            return noUP;
                        }
                        break block15;
                    }
                    catch (Exception ex) {
                        return noUP;
                    }
                }
                keyStr = this.getResourceStringFromURL(masterKey, this.usersUserName, this.usersPassword);
                if (StringUtils.isNotEmpty((String)keyStr)) {
                    try {
                        keyStr = Encryption.decrypt(keyStr, this.usersPassword);
                    }
                    catch (Exception ex) {
                        return noUP;
                    }
                } else {
                    return noUP;
                }
            }
            String[] tokens = StringUtils.split((String)keyStr, (String)",");
            if (tokens.length == 2) {
                return new Pair<String, String>(tokens[0], tokens[1]);
            }
            return noUP;
        }
        return noUP;
    }

    protected boolean askForInfo(Boolean isLocal, String usrName, String dbName, String masterPath) {
        boolean isEditMode;
        String encryptedKey;
        String masterKey;
        UIRegistry.loadAndPushResourceBundle("masterusrpwd");
        FormLayout layout = new FormLayout("p, 2px, f:p:g, 4px, p, 4px, p, 4px, p", "p,2px,p,2px,p,2dlu,p,2dlu,p");
        PanelBuilder pb = new PanelBuilder(layout);
        pb.setDefaultDialogBorder();
        ButtonGroup group = new ButtonGroup();
        final JRadioButton isNetworkRB = new JRadioButton(UIRegistry.getResourceString("IS_NET_BASED"));
        final JRadioButton isPrefBasedRB = new JRadioButton(UIRegistry.getResourceString("IS_ENCRYPTED_KEY"));
        isPrefBasedRB.setSelected(true);
        group.add(isNetworkRB);
        group.add(isPrefBasedRB);
        final JTextField keyTxt = UIHelper.createTextField(35);
        final JTextField urlTxt = UIHelper.createTextField(35);
        final JLabel keyLbl = UIHelper.createI18NFormLabel("ENCRYPTED_USRPWD");
        final JLabel urlLbl = UIHelper.createI18NFormLabel("URL");
        final JButton createBtn = UIHelper.createI18NButton("CREATE_KEY");
        final JButton copyCBBtn = UIHelper.createIconBtn("ClipboardCopy", IconManager.IconSize.Std24, "CPY_TO_CB_TT", null);
        final JButton pasteCBBtn = UIHelper.createIconBtn("ClipboardPaste", IconManager.IconSize.Std24, "CPY_FROM_CB_TT", null);
        String dbNameFromForm = AppPreferences.getLocalPrefs().get("login.databases_selected", null);
        if (StringUtils.isNotEmpty((String)dbNameFromForm) && StringUtils.isNotEmpty((String)this.usersUserName) && StringUtils.isNotEmpty((String)(masterKey = UserAndMasterPasswordMgr.getMasterPrefPath(this.usersUserName, dbNameFromForm, true))) && StringUtils.isNotEmpty((String)(encryptedKey = AppPreferences.getLocalPrefs().get(masterKey, null)))) {
            keyTxt.setText(encryptedKey);
        }
        CellConstraints cc = new CellConstraints();
        int y = 1;
        pb.add((Component)UIHelper.createI18NFormLabel("MASTER_LOC"), cc.xywh(1, y, 1, 3));
        pb.add((Component)isPrefBasedRB, cc.xy(3, y));
        pb.add((Component)isNetworkRB, cc.xy(3, y += 2));
        pb.addSeparator("", cc.xyw(1, y += 2, 9));
        pb.add((Component)keyLbl, cc.xy(1, y += 2));
        pb.add((Component)keyTxt, cc.xy(3, y));
        pb.add((Component)createBtn, cc.xy(5, y));
        pb.add((Component)copyCBBtn, cc.xy(7, y));
        pb.add((Component)pasteCBBtn, cc.xy(9, y));
        pb.add((Component)urlLbl, cc.xy(1, y += 2));
        pb.add((Component)urlTxt, cc.xy(3, y));
        y += 2;
        boolean bl = isEditMode = isLocal != null && StringUtils.isNotEmpty((String)masterPath);
        if (isEditMode) {
            isPrefBasedRB.setSelected(isLocal);
            if (isLocal.booleanValue()) {
                keyTxt.setText(masterPath);
            } else {
                urlTxt.setText(masterPath);
            }
        }
        copyCBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHelper.setTextToClipboard(keyTxt.getText());
            }
        });
        pasteCBBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                keyTxt.setText(UIHelper.getTextFromClipboard());
            }
        });
        final CustomDialog dlg = new CustomDialog(null, UIRegistry.getResourceString("MASTER_TITLE"), true, 7, (Component)pb.getPanel());
        if (!isEditMode) {
            dlg.setOkLabel(UIRegistry.getResourceString("CONT"));
            dlg.setCancelLabel(UIRegistry.getResourceString("BACK"));
        }
        dlg.setHelpContext("MASTERPWD_MAIN");
        dlg.createUI();
        dlg.getOkBtn().setEnabled(false);
        urlLbl.setEnabled(false);
        urlTxt.setEnabled(false);
        copyCBBtn.setEnabled(true);
        pasteCBBtn.setEnabled(true);
        DocumentAdaptor dl = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                dlg.getOkBtn().setEnabled(isPrefBasedRB.isSelected() && !keyTxt.getText().isEmpty() || isNetworkRB.isSelected() && !urlTxt.getText().isEmpty());
            }
        };
        keyTxt.getDocument().addDocumentListener(dl);
        urlTxt.getDocument().addDocumentListener(dl);
        ChangeListener chgListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isNet = isNetworkRB.isSelected();
                keyLbl.setEnabled(!isNet);
                keyTxt.setEnabled(!isNet);
                createBtn.setEnabled(!isNet);
                copyCBBtn.setEnabled(!isNet);
                pasteCBBtn.setEnabled(!isNet);
                urlLbl.setEnabled(isNet);
                urlTxt.setEnabled(isNet);
                dlg.getOkBtn().setEnabled(isPrefBasedRB.isSelected() && !keyTxt.getText().isEmpty() || isNetworkRB.isSelected() && !urlTxt.getText().isEmpty());
            }
        };
        isNetworkRB.addChangeListener(chgListener);
        isPrefBasedRB.addChangeListener(chgListener);
        boolean isPref = AppPreferences.getLocalPrefs().getBoolean(UserAndMasterPasswordMgr.getIsLocalPrefPath(usrName, dbName, true), true);
        isNetworkRB.setSelected(!isPref);
        isPrefBasedRB.setSelected(isPref);
        createBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String encryptedStr;
                String[] keys = UserAndMasterPasswordMgr.this.getUserNamePasswordKey();
                if (keys != null && keys.length == 4 && (encryptedStr = UserAndMasterPasswordMgr.encrypt(keys[0], keys[1], keys[3])) != null) {
                    keyTxt.setText(encryptedStr);
                    dlg.getOkBtn().setEnabled(true);
                    UserAndMasterPasswordMgr.this.usersUserName = keys[2];
                }
            }
        });
        UIRegistry.popResourceBundle();
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            String value = isNetworkRB.isSelected() ? StringEscapeUtils.escapeHtml((String)urlTxt.getText()) : keyTxt.getText();
            AppPreferences.getLocalPrefs().putBoolean(UserAndMasterPasswordMgr.getIsLocalPrefPath(usrName, dbName, true), !isNetworkRB.isSelected());
            AppPreferences.getLocalPrefs().put(UserAndMasterPasswordMgr.getMasterPrefPath(usrName, dbName, true), value);
            return true;
        }
        return false;
    }

    protected String[] getUserNamePasswordKey() {
        UIRegistry.loadAndPushResourceBundle("masterusrpwd");
        FormLayout layout = new FormLayout("p, 4dlu, p, 8px, p", "p, 2dlu, p, 2dlu, p, 16px, p, 2dlu, p, 2dlu, p");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        PanelBuilder pb = new PanelBuilder(layout);
        final JTextField dbUsrTxt = UIHelper.createTextField(30);
        final JPasswordField dbPwdTxt = UIHelper.createPasswordField(30);
        final JTextField usrText = UIHelper.createTextField(30);
        final JPasswordField pwdText = UIHelper.createPasswordField(30);
        final char echoChar = pwdText.getEchoChar();
        JLabel dbUsrLbl = UIHelper.createI18NFormLabel("USERNAME", 4);
        JLabel dbPwdLbl = UIHelper.createI18NFormLabel("PASSWORD", 4);
        JLabel usrLbl = UIHelper.createI18NFormLabel("USERNAME", 4);
        JLabel pwdLbl = UIHelper.createI18NFormLabel("PASSWORD", 4);
        usrText.setText(this.usersUserName);
        CellConstraints cc = new CellConstraints();
        int y = 1;
        pb.addSeparator(UIRegistry.getResourceString("MASTER_SEP"), cc.xyw(1, y, 5));
        pb.add((Component)dbUsrLbl, cc.xy(1, y += 2));
        pb.add((Component)dbUsrTxt, cc.xy(3, y));
        pb.add((Component)dbPwdLbl, cc.xy(1, y += 2));
        pb.add((Component)dbPwdTxt, cc.xy(3, y));
        pb.addSeparator(UIRegistry.getResourceString("USER_SEP"), cc.xyw(1, y += 2, 5));
        pb.add((Component)usrLbl, cc.xy(1, y += 2));
        pb.add((Component)usrText, cc.xy(3, y));
        pb.add((Component)pwdLbl, cc.xy(1, y += 2));
        pb.add((Component)pwdText, cc.xy(3, y));
        pb.setDefaultDialogBorder();
        final CustomDialog dlg = new CustomDialog(null, UIRegistry.getResourceString("MASTER_INFO_TITLE"), true, 15, (Component)pb.getPanel());
        dlg.setOkLabel(UIRegistry.getResourceString("GENERATE_KEY"));
        dlg.setHelpContext("MASTERPWD_GEN");
        dlg.setApplyLabel(this.showPwdLabel);
        dlg.createUI();
        dlg.getOkBtn().setEnabled(false);
        UIRegistry.popResourceBundle();
        DocumentAdaptor docListener = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                boolean enable;
                String dbUserStr = dbUsrTxt.getText();
                boolean bl = enable = !dbUserStr.isEmpty() && !((JTextComponent)dbPwdTxt).getText().isEmpty() && !usrText.getText().isEmpty() && !((JTextComponent)pwdText).getText().isEmpty();
                if (enable && StringUtils.isNotEmpty((String)dbUserStr) && dbUserStr.equalsIgnoreCase("root")) {
                    UIRegistry.loadAndPushResourceBundle("masterusrpwd");
                    UIRegistry.showLocalizedError("MASTER_NO_ROOT");
                    UIRegistry.popResourceBundle();
                    enable = false;
                }
                dlg.getOkBtn().setEnabled(enable);
            }
        };
        dbUsrTxt.getDocument().addDocumentListener(docListener);
        dbPwdTxt.getDocument().addDocumentListener(docListener);
        usrText.getDocument().addDocumentListener(docListener);
        pwdText.getDocument().addDocumentListener(docListener);
        this.currEcho = echoChar;
        dlg.getApplyBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.getApplyBtn().setText(UserAndMasterPasswordMgr.this.currEcho == echoChar ? UserAndMasterPasswordMgr.this.hidePwdLabel : UserAndMasterPasswordMgr.this.showPwdLabel);
                UserAndMasterPasswordMgr.this.currEcho = UserAndMasterPasswordMgr.this.currEcho == echoChar ? (char)'\u0000' : echoChar;
                pwdText.setEchoChar(UserAndMasterPasswordMgr.this.currEcho);
                dbPwdTxt.setEchoChar(UserAndMasterPasswordMgr.this.currEcho);
            }
        });
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            return new String[]{dbUsrTxt.getText(), ((JTextComponent)dbPwdTxt).getText(), usrText.getText(), ((JTextComponent)pwdText).getText()};
        }
        return null;
    }

    protected String getResourceStringFromURL(String urlLoc, String username, String password) {
        String encrytpedStr = Encryption.encrypt(String.valueOf(username) + "," + password, username);
        String fullURL = String.valueOf(urlLoc) + "?data=" + encrytpedStr + ";db=" + DBConnection.getInstance().getDatabaseName();
        Exception exception = null;
        BufferedReader bufRdr = null;
        try {
            String s;
            URL url = new URL(fullURL);
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            StringBuilder sb = new StringBuilder();
            bufRdr = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            while ((s = bufRdr.readLine()) != null) {
                sb.append(s);
            }
            bufRdr.close();
            String string = sb.toString();
            return string;
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            exception = mue;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            exception = ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exception = ex;
        }
        finally {
            try {
                if (bufRdr != null) {
                    bufRdr.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                exception = ioe;
            }
        }
        if (exception != null) {
            UIRegistry.showLocalizedError("WEBSRV_ERROR", exception.toString());
        }
        return null;
    }

    public static String encrypt(String username, String password, String encyptionKey) {
        return Encryption.encrypt(String.valueOf(username) + "," + password, encyptionKey);
    }

    public boolean changePassword() {
        UIRegistry.loadAndPushResourceBundle("masterusrpwd");
        final ViewBasedDisplayDialog dlg = new ViewBasedDisplayDialog((Frame)UIRegistry.getTopWindow(), "SystemSetup", "ChangePassword", null, UIRegistry.getResourceString(UIRegistry.getResourceString("CHG_PWD_TITLE")), "OK", null, null, true, 792);
        dlg.setHelpContext("CHANGE_PWD");
        dlg.setWhichBtns(3);
        dlg.setFormAdjuster(new FormPane.FormPaneAdjusterIFace(){

            @Override
            public void adjustForm(FormViewObj fvo) {
                ValPasswordField oldPwdVTF = (ValPasswordField)fvo.getCompById("1");
                final ValPasswordField newPwdVTF = (ValPasswordField)fvo.getCompById("2");
                ValPasswordField verPwdVTF = (ValPasswordField)fvo.getCompById("3");
                final PasswordStrengthUI pwdStrenthUI = (PasswordStrengthUI)fvo.getCompById("4");
                DocumentAdaptor da = new DocumentAdaptor(){

                    @Override
                    protected void changed(DocumentEvent e) {
                        super.changed(e);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean enabled = dlg.getOkBtn().isEnabled();
                                String pwdStr = new String(newPwdVTF.getPassword());
                                boolean pwdOK = pwdStrenthUI.checkStrength(pwdStr);
                                dlg.getOkBtn().setEnabled(enabled && pwdOK);
                                pwdStrenthUI.repaint();
                            }
                        });
                    }
                };
                oldPwdVTF.getDocument().addDocumentListener(da);
                verPwdVTF.getDocument().addDocumentListener(da);
                newPwdVTF.getDocument().addDocumentListener(da);
            }
        });
        Hashtable valuesHash = new Hashtable();
        dlg.setData(valuesHash);
        UIHelper.centerAndShow(dlg);
        if (!dlg.isCancelled()) {
            String newPwd2;
            int pwdLen = 6;
            String oldPwd = (String)valuesHash.get("OldPwd");
            String newPwd1 = (String)valuesHash.get("NewPwd1");
            if (newPwd1.equals(newPwd2 = (String)valuesHash.get("NewPwd2"))) {
                if (newPwd1.length() < pwdLen) {
                    SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                    String spuOldPwd = spUser.getPassword();
                    if (oldPwd.equals(spuOldPwd)) {
                        UIRegistry.popResourceBundle();
                        return this.changePassword(oldPwd, newPwd2);
                    }
                    UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(UIRegistry.getResourceString("PWD_ERR_BAD")), Color.RED);
                } else {
                    UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getFormattedResStr(UIRegistry.getResourceString("PWD_ERR_LEN"), pwdLen), Color.RED);
                }
            } else {
                UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(UIRegistry.getResourceString("PWD_ERR_NOTSAME")), Color.RED);
            }
        }
        UIRegistry.popResourceBundle();
        return false;
    }

    protected boolean changePassword(String oldPwd, String newPwd) {
        SpecifyUser spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
        Pair<String, String> masterPwd = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
        String encryptedMasterUP = UserAndMasterPasswordMgr.encrypt((String)masterPwd.first, (String)masterPwd.second, newPwd);
        if (StringUtils.isNotEmpty((String)encryptedMasterUP)) {
            AppPreferences.getLocalPrefs().put(this.getMasterPrefPath(true), encryptedMasterUP);
            spUser.setPassword(newPwd);
            if (DataModelObjBase.save(spUser)) {
                return true;
            }
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(UIRegistry.getResourceString("PWD_ERR_SAVE")), Color.RED);
        } else {
            UIRegistry.writeTimedSimpleGlassPaneMsg(UIRegistry.getResourceString(UIRegistry.getResourceString("PWD_ERR_RTRV")), Color.RED);
        }
        return false;
    }

    public boolean createUser(String username, String password) {
        return true;
    }

    public boolean deleteUser(String username, String password) {
        return true;
    }

    public static UserAndMasterPasswordMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(UserAndMasterPasswordMgr.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (UserAndMasterPasswordMgr)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UserAndMasterPasswordMgr.class, e);
                InternalError error = new InternalError("Can't instantiate UserAndMasterPasswordMgr factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        instance = new UserAndMasterPasswordMgr();
        return instance;
    }
}

