/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.ui.IconManager;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;

public class SecurityOption
implements SecurityOptionIFace {
    protected String name;
    protected String title;
    protected String prefix;
    protected String shortDesc = "";
    protected ImageIcon icon = null;
    protected String iconName = null;
    protected PermissionEditorIFace editor;
    protected PermissionIFace permissions = null;
    protected Hashtable<String, PermissionIFace> defaultPermissionsHash = new Hashtable();

    public SecurityOption(String name, String title, String prefix) {
        this(name, title, prefix, (PermissionEditorIFace)null);
    }

    public SecurityOption(String name, String title, String prefix, PermissionEditorIFace editor) {
        this.name = name;
        this.title = title;
        this.prefix = prefix;
        this.editor = editor;
    }

    public SecurityOption(String name, String title, String prefix, String iconName) {
        this.name = name;
        this.title = title;
        this.prefix = prefix;
        this.iconName = iconName;
        this.editor = null;
    }

    public void setEditor(PermissionEditorIFace editor) {
        this.editor = editor;
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return this.editor;
    }

    @Override
    public String getPermissionName() {
        return this.name;
    }

    @Override
    public PermissionIFace getPermissions() {
        if (this.permissions == null) {
            this.permissions = SecurityMgr.getInstance().getPermission(String.valueOf(this.prefix) + "." + this.getPermissionName());
        }
        return this.permissions;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc == null ? this.title : this.shortDesc;
    }

    public void setSecurityTitle(String title) {
        this.title = title;
    }

    @Override
    public String getPermissionTitle() {
        return this.title;
    }

    @Override
    public void setPermissions(PermissionIFace permissions) {
        this.permissions = permissions;
    }

    @Override
    public List<SecurityOptionIFace> getAdditionalSecurityOptions() {
        return null;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    @Override
    public ImageIcon getIcon(int size) {
        if (this.iconName != null) {
            IconManager.IconSize[] iconSizeArray = IconManager.IconSize.values();
            int n = iconSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconManager.IconSize iconSize = iconSizeArray[n2];
                if (iconSize.size() == size) {
                    return IconManager.getIcon(this.iconName, iconSize);
                }
                ++n2;
            }
        }
        return this.icon;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void addDefaultPerm(String userType, PermissionIFace defaultPerms) {
        this.defaultPermissionsHash.put(userType, defaultPerms);
    }

    @Override
    public PermissionIFace getDefaultPermissions(String userType) {
        return this.defaultPermissionsHash.get(userType);
    }
}

