/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;

public class SecurityMgr {
    public static final String factoryName = "edu.ku.brc.af.auth.SecurityMgr";
    public static final String VIEW_PERM = "view";
    public static final String MODIFY_PERM = "modify";
    public static final String DELETE_PERM = "delete";
    public static final String ADD_PERM = "add";
    protected static SecurityMgr instance = null;

    protected SecurityMgr() {
    }

    public static SecurityMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(SecurityMgr.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (SecurityMgr)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                e.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SecurityMgr.class, e);
                InternalError error = new InternalError("Can't instantiate SecurityMgr factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }

    public boolean authenticateDB(String user, String pass, String driverClass, String url, String dbUserName, String dbPwd) throws Exception {
        return false;
    }

    public void grantPermission(Subject currentSubject, Principal principalToMatchTo, Permission perm) {
    }

    public boolean checkPermission(String name, String actions) {
        return true;
    }

    public PermissionSettings getPermission(String name) {
        return new PermissionSettings(15);
    }
}

