/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import edu.ku.brc.af.core.PermissionIFace;
import org.apache.log4j.Logger;

public class PermissionSettings
implements PermissionIFace {
    private static final Logger log = Logger.getLogger(PermissionSettings.class);
    public static final int NO_PERM = 0;
    public static final int CAN_VIEW = 1;
    public static final int CAN_MODIFY = 2;
    public static final int CAN_DELETE = 4;
    public static final int CAN_ADD = 8;
    public static final int ALL_PERM = 15;
    private int permissions;

    public PermissionSettings(int permissions) {
        this.permissions = permissions;
    }

    public PermissionSettings(boolean canView, boolean canModify, boolean canDel, boolean canAdd) {
        this.setCanView(canView);
        this.setCanModify(canModify);
        this.setCanDelete(canDel);
        this.setCanAdd(canAdd);
    }

    @Override
    public boolean canModify() {
        return PermissionSettings.isOn(this.permissions, 2);
    }

    @Override
    public boolean canView() {
        return PermissionSettings.isOn(this.permissions, 1);
    }

    @Override
    public boolean canAdd() {
        return PermissionSettings.isOn(this.permissions, 8);
    }

    @Override
    public boolean canDelete() {
        return PermissionSettings.isOn(this.permissions, 4);
    }

    @Override
    public void setCanAdd(boolean value) {
        this.permissions = value ? (this.permissions |= 8) : (this.permissions &= 0xFFFFFFF7);
    }

    @Override
    public void setCanDelete(boolean value) {
        this.permissions = value ? (this.permissions |= 4) : (this.permissions &= 0xFFFFFFFB);
    }

    @Override
    public void setCanModify(boolean value) {
        this.permissions = value ? (this.permissions |= 2) : (this.permissions &= 0xFFFFFFFD);
    }

    @Override
    public void setCanView(boolean value) {
        this.permissions = value ? (this.permissions |= 1) : (this.permissions &= 0xFFFFFFFE);
    }

    @Override
    public boolean isViewOnly() {
        return this.permissions == 1;
    }

    @Override
    public int getOptions() {
        return this.permissions;
    }

    @Override
    public void clear() {
        this.permissions = 0;
    }

    @Override
    public boolean hasNoPerm() {
        return this.permissions == 0;
    }

    @Override
    public void setOptions(int options) {
        this.permissions = options;
    }

    public static boolean isOn(int options, int opt) {
        return (options & opt) == opt;
    }

    public static boolean canModify(int options) {
        return PermissionSettings.isOn(options, 2);
    }

    public static boolean canView(int options) {
        return PermissionSettings.isOn(options, 1);
    }

    public static boolean canAdd(int options) {
        return PermissionSettings.isOn(options, 8);
    }

    public static boolean canDelete(int options) {
        return PermissionSettings.isOn(options, 4);
    }

    public static void dumpPermissions(String title, int options) {
        log.debug((Object)(String.valueOf(title) + " - View: " + (PermissionSettings.canView(options) ? "Y" : "N") + " Modify: " + (PermissionSettings.canModify(options) ? "Y" : "N") + " Delete: " + (PermissionSettings.canDelete(options) ? "Y" : "N") + " Add: " + (PermissionSettings.canAdd(options) ? "Y" : "N")));
    }
}

