/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import edu.ku.brc.af.auth.specify.module.DbLoginCallbackHandler;
import edu.ku.brc.af.auth.specify.module.SpDBConfiguration;
import edu.ku.brc.af.auth.specify.policy.DatabasePolicy;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.Policy;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class JaasContext {
    private static final Logger log = Logger.getLogger(JaasContext.class);
    public static String url = "";
    public static String driver = "";
    public static Subject globalSubject = null;

    public void createDatabaseBackedPolicyDefinition() {
        Policy.setPolicy(new DatabasePolicy());
    }

    public boolean jaasLogin(String user, String pass, String urlArg, String driverArg, String dbUserName, String dbPwd) {
        globalSubject = null;
        url = urlArg;
        driver = driverArg;
        boolean loginSuccess = false;
        try {
            Configuration.setConfiguration(SpDBConfiguration.getInstance());
            this.createDatabaseBackedPolicyDefinition();
            DbLoginCallbackHandler spcbh = new DbLoginCallbackHandler(user, pass, urlArg, driverArg, dbUserName, dbPwd);
            LoginContext loginContext = new LoginContext("SpLogin", spcbh);
            loginContext.login();
            loginSuccess = true;
            globalSubject = loginContext.getSubject();
        }
        catch (LoginException lex) {
            log.error((Object)("jaasLogin() - " + lex.getClass().getName() + ": " + lex.getMessage()));
            log.error((Object)"jaasLogin() - user failed to login using through jaas framework");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(JaasContext.class, ex);
            log.error((Object)("jaasLogin() - " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        return loginSuccess;
    }

    public static Subject getGlobalSubject() {
        return globalSubject;
    }
}

