/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.log4j.Logger;

public class DbLoginCallbackHandler
implements CallbackHandler {
    protected static final Logger log = Logger.getLogger(DbLoginCallbackHandler.class);
    protected String user = "";
    protected String pass = "";
    protected String url = "";
    protected String driver = "";
    protected String dbUserName = "";
    protected String dbPwd = "";

    public DbLoginCallbackHandler(String user, String pass, String url, String driver, String dbUserName, String dbPwd) {
        this.user = user;
        this.pass = pass;
        this.url = url;
        this.driver = driver;
        this.dbUserName = dbUserName;
        this.dbPwd = dbPwd;
        log.debug((Object)"DbLoginCallbackHandler() created");
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        log.debug((Object)"handle");
        try {
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i] instanceof NameCallback) {
                    log.debug((Object)"handle - [NameCallback]");
                    log.debug((Object)("handle - got user:" + this.user));
                    ((NameCallback)callbacks[i]).setName(this.user);
                } else if (callbacks[i] instanceof PasswordCallback) {
                    log.debug((Object)"handle - [PasswordCallback]");
                    ((PasswordCallback)callbacks[i]).setPassword(this.pass.toCharArray());
                } else if (callbacks[i] instanceof TextInputCallback) {
                    log.debug((Object)"handle - [TextInputCallback]");
                    if (((TextInputCallback)callbacks[i]).getPrompt().equals("Url:")) {
                        log.debug((Object)("handle - got url:" + this.url));
                        ((TextInputCallback)callbacks[i]).setText(this.url);
                    } else if (((TextInputCallback)callbacks[i]).getPrompt().equals("Driver:")) {
                        log.debug((Object)("handle - got driver:" + this.driver));
                        ((TextInputCallback)callbacks[i]).setText(this.driver);
                    } else if (((TextInputCallback)callbacks[i]).getPrompt().equals("DBUserName:")) {
                        ((TextInputCallback)callbacks[i]).setText(this.dbUserName);
                    } else if (((TextInputCallback)callbacks[i]).getPrompt().equals("DBPwd:")) {
                        ((TextInputCallback)callbacks[i]).setText(this.dbPwd);
                    }
                } else {
                    throw new UnsupportedCallbackException(callbacks[i], "Callback class not supported");
                }
                ++i;
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DbLoginCallbackHandler.class, e);
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

