/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.auth;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BasicPermisionPanel
extends JPanel
implements PermissionEditorIFace {
    protected PermissionIFace permissions = null;
    protected JCheckBox viewChk;
    protected JCheckBox addChk;
    protected JCheckBox modifyChk;
    protected JCheckBox delChk;
    protected JLabel label = new JLabel();
    protected String[] originalLabels = new String[4];
    protected int[] tableIds = null;
    protected boolean hasChanged = false;

    public BasicPermisionPanel() {
        this(null, "SEC_PERM", "SEC_VIEW_TITLE", "SEC_ADD_TITLE", "SEC_MOD_TITLE", "SEC_DEL_TITLE");
    }

    public BasicPermisionPanel(ChangeListener changeListener) {
        this(changeListener, "SEC_PERM", "SEC_VIEW_TITLE", "SEC_MOD_TITLE", "SEC_ADD_TITLE", "SEC_DEL_TITLE");
    }

    public BasicPermisionPanel(String titleKey, String viewKey) {
        this(null, titleKey, viewKey, null, null, null);
    }

    public BasicPermisionPanel(String titleKey, String viewKey, String modKey) {
        this(null, titleKey, viewKey, modKey, null, null);
    }

    public BasicPermisionPanel(String titleKey, String viewKey, String modKey, String addKey, String delKey) {
        this(null, titleKey, viewKey, modKey, addKey, delKey);
    }

    public BasicPermisionPanel(ChangeListener changeListener, String titleKey, String viewKey, String modKey, String addKey, String delKey) {
        CellConstraints cc = new CellConstraints();
        int numRows = addKey != null ? 1 : 0;
        numRows += delKey != null ? 1 : 0;
        numRows += modKey != null ? 1 : 0;
        numRows += viewKey != null ? 1 : 0;
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,f:p:g", UIHelper.createDuplicateJGoodiesDef("p", "4px", ++numRows)), (JPanel)this);
        this.originalLabels[0] = viewKey != null ? UIRegistry.getResourceString(viewKey) : null;
        this.originalLabels[1] = modKey != null ? UIRegistry.getResourceString(modKey) : null;
        this.originalLabels[2] = addKey != null ? UIRegistry.getResourceString(addKey) : null;
        this.originalLabels[3] = delKey != null ? UIRegistry.getResourceString(delKey) : null;
        int y = 1;
        PanelBuilder sepPB = new PanelBuilder(new FormLayout("p,0px,f:p:g", "p"));
        sepPB.add((Component)this.label, cc.xy(1, 1));
        sepPB.addSeparator(" ", cc.xy(3, 1));
        pb.add((Component)sepPB.getPanel(), cc.xyw(1, y, 2));
        y += 2;
        if (viewKey != null) {
            this.viewChk = UIHelper.createCheckBox(this.originalLabels[0]);
            pb.add((Component)this.viewChk, cc.xy(1, y));
        }
        y += 2;
        if (modKey != null) {
            this.modifyChk = UIHelper.createCheckBox(this.originalLabels[1]);
            pb.add((Component)this.modifyChk, cc.xy(1, y));
        }
        y += 2;
        if (addKey != null) {
            this.addChk = UIHelper.createCheckBox(this.originalLabels[2]);
            pb.add((Component)this.addChk, cc.xy(1, y));
        }
        y += 2;
        if (delKey != null) {
            this.delChk = UIHelper.createCheckBox(this.originalLabels[3]);
            pb.add((Component)this.delChk, cc.xy(1, y));
        }
        y += 2;
        this.addChangeListener(changeListener);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BasicPermisionPanel.this.hasChanged = true;
            }
        });
    }

    @Override
    public void setTitle(String title) {
        this.label.setText(title);
    }

    @Override
    public void setOverrideText(int option, String text, boolean isReadOnly) {
        boolean hasText = text != null;
        switch (option) {
            case 1: {
                if (this.viewChk == null) break;
                this.viewChk.setText(String.valueOf(this.originalLabels[0]) + (hasText ? " (" + text + ")" : ""));
                this.viewChk.setEnabled(!hasText && !isReadOnly);
                break;
            }
            case 2: {
                if (this.modifyChk == null) break;
                this.modifyChk.setText(String.valueOf(this.originalLabels[1]) + (hasText ? " (" + text + ")" : ""));
                this.modifyChk.setEnabled(!hasText && !isReadOnly);
                break;
            }
            case 8: {
                if (this.addChk == null) break;
                this.addChk.setText(String.valueOf(this.originalLabels[2]) + (hasText ? " (" + text + ")" : ""));
                this.addChk.setEnabled(!hasText && !isReadOnly);
                break;
            }
            case 4: {
                if (this.delChk == null) break;
                this.delChk.setText(String.valueOf(this.originalLabels[3]) + (hasText ? " (" + text + ")" : ""));
                this.delChk.setEnabled(!hasText && !isReadOnly);
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            if (this.viewChk != null) {
                this.viewChk.addChangeListener(changeListener);
            }
            if (this.addChk != null) {
                this.addChk.addChangeListener(changeListener);
            }
            if (this.modifyChk != null) {
                this.modifyChk.addChangeListener(changeListener);
            }
            if (this.delChk != null) {
                this.delChk.addChangeListener(changeListener);
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            if (this.viewChk != null) {
                this.viewChk.removeChangeListener(changeListener);
            }
            if (this.addChk != null) {
                this.addChk.removeChangeListener(changeListener);
            }
            if (this.modifyChk != null) {
                this.modifyChk.removeChangeListener(changeListener);
            }
            if (this.delChk != null) {
                this.delChk.removeChangeListener(changeListener);
            }
        }
    }

    @Override
    public Component getUIComponent() {
        return this;
    }

    @Override
    public List<PermissionIFace> getPermissions() {
        ArrayList<PermissionIFace> list = new ArrayList<PermissionIFace>(1);
        this.permissions.clear();
        if (this.addChk != null) {
            this.permissions.setCanAdd(this.addChk.isSelected());
        }
        if (this.delChk != null) {
            this.permissions.setCanDelete(this.delChk.isSelected());
        }
        if (this.modifyChk != null) {
            this.permissions.setCanModify(this.modifyChk.isSelected());
        }
        if (this.viewChk != null) {
            System.out.println(this.viewChk.isSelected());
            this.permissions.setCanView(this.viewChk.isSelected());
        }
        list.add(this.permissions);
        return list;
    }

    @Override
    public void setPermissions(List<PermissionIFace> permissionsArg) {
        this.permissions = permissionsArg.get(0);
        if (this.viewChk != null) {
            this.viewChk.setSelected(this.permissions.canView());
        }
        if (this.addChk != null) {
            this.addChk.setSelected(this.permissions.canAdd());
        }
        if (this.modifyChk != null) {
            this.modifyChk.setSelected(this.permissions.canModify());
        }
        if (this.delChk != null) {
            this.delChk.setSelected(this.permissions.canDelete());
        }
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void setChanged(boolean changed) {
        this.hasChanged = changed;
    }

    @Override
    public int[] getAssociatedTableIds() {
        return this.tableIds;
    }

    public void setAssociatedTableIds(int[] tableIds) {
        this.tableIds = tableIds;
    }
}

