'
'Title: toggleICF.vbs
'Purpose: turn on and turn off the Internet Connection Firewall on all or a specified interface
'Platform: Windows XP
'Requirement: Wscript.exe
'
'Author:  Erik Pace Birkholz, erik@specialopssecurity.com
'Date: 8-16-02
'www.SpecialOpsSecurity.com
'
'Things I want to add when i have time
'1. use the InternetFirewallEnabled to verify the interface status
'2. list all available interfaces when invalid input is entered


OPTION EXPLICIT

DIM CONNECTION_ALL
DIM NetSharingManager
DIM EveryConnectionCollection

DIM Arguments
DIM Interface 
DIM UpDown
DIM delete
DIM deleteme
DIM deletemetoo
DIM List

CONNECTION_ALL        = 2

Set Arguments = WScript.Arguments

if (Arguments.Count = 2) then
    Interface = Arguments(0)
    UpDown = Arguments(1)
    	if (UpDown="on" or UpDown="off" or UpDown="ON" or UpDown="OFF" or UpDown="On" or UpDown="Off") then
               	if initialize() = TRUE then    
        		if GetConnectionObjects() = TRUE then
        			if FirewallTestByName(Interface) = TRUE then
        				WScript.Echo "ICF has been turned " + UpDown + " for " + Interface + " interface(s)"
            			else
        				WScript.Echo "  " + "Correct usage:   " + WScript.scriptname + " " + chr(34) + "<interface>" + chr(34) + "<on|off>" + vbCRLF + vbCRLF + "    --Please enter a VALID interface name or ALL--"
        				'LIST INTERFACES HERE ONCE I FIGURE OUT HOW TO MAKE A FEW THINGS GO IN A POP-UP OR ON A WINDOW
        			end if
        		end if
    		end if
    	else
    		WScript.Echo "  " + "Correct usage:   " + WScript.scriptname + " " + chr(34) + "<interface>" + chr(34) + "<on|off>" + vbCRLF + vbCRLF + "       --Please enter either ON or OFF--    "
    	end if
else
	WScript.Echo "  " + "Correct usage:   " + WScript.scriptname + " " + chr(34) + "<interface>" + chr(34) + "<on|off>" + vbCRLF + vbCRLF + "   --Both arguments are required for correct operation--     "
end if




function FirewallTestByName(InterfaceName)
on error resume next
    DIM Item
    DIM EveryConnection
    DIM Properties
    DIM InterfaceExist
    
    InterfaceExist = FALSE
    for each Item in EveryConnectionCollection
        set EveryConnection = NetSharingManager.INetSharingConfigurationForINetConnection(Item)
       	set Properties = NetSharingManager.NetConnectionProps(Item)
        if (InterfaceName="all" or InterfaceName="ALL") then     
            InterfaceExist = TRUE
        	if (UpDown="on" or UpDown="ON" or UpDown="On") then
            		EveryConnection.EnableInternetFirewall
            	elseif (UpDown="off" or UpDown="OFF" or UpDown="Off") then
            		EveryConnection.DisableInternetFirewall
            	end if
            
        elseif (ucase(InterfaceName) = ucase(Properties.Name)) then
            InterfaceExist = TRUE
            
            if (UpDown="on" or UpDown="ON" or UpDown="On") then
            	EveryConnection.EnableInternetFirewall
            elseif (UpDown="off" or UpDown="OFF" or UpDown="Off") then
            	EveryConnection.DisableInternetFirewall
            end if
            	
            exit for       
        end if
    next
    FirewallTestByName = InterfaceExist
end function




function Initialize()
'output: TRUE or FALSE

    DIM Return
    Return = FALSE
    set NetSharingManager = Wscript.CreateObject("HNetCfg.HNetShare.1")
    if (IsObject(NetSharingManager)) = FALSE then
        Wscript.Echo("The Internet Sharing Manager cannot be contacted.  Internet Connection Firewall may not be available on this interface.")
    else
        if (IsNull(NetSharingManager.SharingInstalled) = TRUE) then
            Wscript.Echo("Internet Connection Firewall may not be available on this interface.")
        else
            Return = TRUE
        end if
    end if
    Initialize = Return
end function




function GetConnectionObjects()
 
    DIM Return
    DIM Item
    
    Return = TRUE
    
    if GetConnection(CONNECTION_ALL) = FALSE then
        Return = FALSE
    end if
    
    GetConnectionObjects = Return     
 
end function


function GetConnection(CONNECTION_TYPE)

    DIM Return     
    DIM Connection
    DIM Item
    Return = TRUE
    
    
    if (CONNECTION_ALL = CONNECTION_TYPE) then
        set Connection = NetSharingManager.EnumEveryConnection
        
        if (Connection.Count > 0) then
            set EveryConnectionCollection = Connection
        else
            Return = FALSE
        end if
        
    else
        Return = FALSE
    end if
	
    GetConnection = Return
end function